/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.document;

import com.lowagie.text.DocWriter;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import java.io.IOException;
import java.io.OutputStream;

public class RtfFootnoteSetting
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] FOOTNOTE_BOTTOM = DocWriter.getISOBytes("\\ftnbj");
    private static final byte[] FOOTNOTE_START = DocWriter.getISOBytes("\\ftnstart");
    private static final byte[] FOOTNOTE_CONTINUOUS = DocWriter.getISOBytes("\\ftnrscont");
    private static final byte[] FOOTNOTE_ARABIC = DocWriter.getISOBytes("\\ftnnar");
    private static final byte[] FOOTNOTE_SEP = DocWriter.getISOBytes("\\*\\ftnsep");
    private static final byte[] FOOTNOTE_ANCHOR = DocWriter.getISOBytes("\\chftnsep");
    private int footnoteStart = 1;

    public RtfFootnoteSetting(RtfDocument doc) {
        super(doc);
    }

    public int getFootnoteStart() {
        return this.footnoteStart;
    }

    public void setFootnoteStart(int footnoteStart) {
        this.footnoteStart = footnoteStart;
    }

    @Override
    public void writeContent(OutputStream out) {
    }

    @Override
    public void writeDefinition(OutputStream result) throws IOException {
        result.write(FOOTNOTE_BOTTOM);
        result.write(FOOTNOTE_START);
        result.write(RtfFootnoteSetting.intToByteArray(this.footnoteStart));
        result.write(FOOTNOTE_CONTINUOUS);
        result.write(FOOTNOTE_ARABIC);
        result.write(OPEN_GROUP);
        result.write(FOOTNOTE_SEP);
        result.write(FOOTNOTE_ANCHOR);
        result.write(CLOSE_GROUP);
        this.document.outputDebugLinebreak(result);
    }
}

