/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.field;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocWriter;
import com.lowagie.text.Font;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfFont;
import java.io.IOException;
import java.io.OutputStream;

public abstract class RtfField
extends Chunk
implements RtfBasicElement {
    private static final byte[] FIELD = DocWriter.getISOBytes("\\field");
    private static final byte[] FIELD_DIRTY = DocWriter.getISOBytes("\\flddirty");
    private static final byte[] FIELD_PRIVATE = DocWriter.getISOBytes("\\fldpriv");
    private static final byte[] FIELD_LOCKED = DocWriter.getISOBytes("\\fldlock");
    private static final byte[] FIELD_EDIT = DocWriter.getISOBytes("\\fldedit");
    private static final byte[] FIELD_ALT = DocWriter.getISOBytes("\\fldalt");
    private static final byte[] FIELD_INSTRUCTIONS = DocWriter.getISOBytes("\\*\\fldinst");
    private static final byte[] FIELD_RESULT = DocWriter.getISOBytes("\\fldrslt");
    private boolean fieldDirty = false;
    private boolean fieldEdit = false;
    private boolean fieldLocked = false;
    private boolean fieldPrivate = false;
    private boolean fieldAlt = false;
    private boolean inTable = false;
    private boolean inHeader = false;
    protected RtfDocument document;
    private RtfFont font;

    protected RtfField(RtfDocument doc) {
        this(doc, new Font());
    }

    protected RtfField(RtfDocument doc, Font font) {
        super("", font);
        this.document = doc;
        this.font = new RtfFont(this.document, font);
    }

    @Override
    public void setRtfDocument(RtfDocument doc) {
        this.document = doc;
        this.font.setRtfDocument(this.document);
    }

    private void writeFieldBegin(OutputStream result) throws IOException {
        result.write(OPEN_GROUP);
        result.write(FIELD);
        if (this.fieldDirty) {
            result.write(FIELD_DIRTY);
        }
        if (this.fieldEdit) {
            result.write(FIELD_EDIT);
        }
        if (this.fieldLocked) {
            result.write(FIELD_LOCKED);
        }
        if (this.fieldPrivate) {
            result.write(FIELD_PRIVATE);
        }
    }

    private void writeFieldInstBegin(OutputStream result) throws IOException {
        result.write(OPEN_GROUP);
        result.write(FIELD_INSTRUCTIONS);
        result.write(DELIMITER);
    }

    protected abstract void writeFieldInstContent(OutputStream var1) throws IOException;

    private void writeFieldInstEnd(OutputStream result) throws IOException {
        if (this.fieldAlt) {
            result.write(DELIMITER);
            result.write(FIELD_ALT);
        }
        result.write(CLOSE_GROUP);
    }

    private void writeFieldResultBegin(OutputStream result) throws IOException {
        result.write(OPEN_GROUP);
        result.write(FIELD_RESULT);
        result.write(DELIMITER);
    }

    protected abstract void writeFieldResultContent(OutputStream var1) throws IOException;

    private void writeFieldResultEnd(OutputStream result) throws IOException {
        result.write(DELIMITER);
        result.write(CLOSE_GROUP);
    }

    private void writeFieldEnd(OutputStream result) throws IOException {
        result.write(CLOSE_GROUP);
    }

    @Override
    public void writeContent(OutputStream result) throws IOException {
        this.font.writeBegin(result);
        this.writeFieldBegin(result);
        this.writeFieldInstBegin(result);
        this.writeFieldInstContent(result);
        this.writeFieldInstEnd(result);
        this.writeFieldResultBegin(result);
        this.writeFieldResultContent(result);
        this.writeFieldResultEnd(result);
        this.writeFieldEnd(result);
        this.font.writeEnd(result);
    }

    public boolean isFieldAlt() {
        return this.fieldAlt;
    }

    public void setFieldAlt(boolean fieldAlt) {
        this.fieldAlt = fieldAlt;
    }

    public boolean isFieldDirty() {
        return this.fieldDirty;
    }

    public void setFieldDirty(boolean fieldDirty) {
        this.fieldDirty = fieldDirty;
    }

    public boolean isFieldEdit() {
        return this.fieldEdit;
    }

    public void setFieldEdit(boolean fieldEdit) {
        this.fieldEdit = fieldEdit;
    }

    public boolean isFieldLocked() {
        return this.fieldLocked;
    }

    public void setFieldLocked(boolean fieldLocked) {
        this.fieldLocked = fieldLocked;
    }

    public boolean isFieldPrivate() {
        return this.fieldPrivate;
    }

    public void setFieldPrivate(boolean fieldPrivate) {
        this.fieldPrivate = fieldPrivate;
    }

    @Override
    public void setInTable(boolean inTable) {
        this.inTable = inTable;
    }

    public boolean isInTable() {
        return this.inTable;
    }

    @Override
    public void setInHeader(boolean inHeader) {
        this.inHeader = inHeader;
    }

    public boolean isInHeader() {
        return this.inHeader;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.font = new RtfFont(this.document, font);
    }
}

