/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.graphic;

import com.lowagie.text.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class MetaDo {
    private static final int META_SETMAPMODE = 259;
    private static final int META_SETWINDOWORG = 523;
    private static final int META_SETWINDOWEXT = 524;
    private static final int META_DIBSTRETCHBLT = 2881;

    MetaDo() {
    }

    static byte[] wrapBMP(Image image) throws IOException {
        byte[] data;
        if (image.getOriginalType() != 4) {
            throw new IOException("Only BMP can be wrapped in WMF.");
        }
        if (image.getOriginalData() == null) {
            try (InputStream imgIn = image.getUrl().openStream();){
                int b;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while ((b = imgIn.read()) != -1) {
                    out.write(b);
                }
                data = out.toByteArray();
            }
        } else {
            data = image.getOriginalData();
        }
        int sizeBmpWords = data.length - 14 + 1 >>> 1;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        MetaDo.writeWord(os, 1);
        MetaDo.writeWord(os, 9);
        MetaDo.writeWord(os, 768);
        MetaDo.writeDWord(os, 23 + (13 + sizeBmpWords) + 3);
        MetaDo.writeWord(os, 1);
        MetaDo.writeDWord(os, 14 + sizeBmpWords);
        MetaDo.writeWord(os, 0);
        MetaDo.writeDWord(os, 4);
        MetaDo.writeWord(os, 259);
        MetaDo.writeWord(os, 8);
        MetaDo.writeDWord(os, 5);
        MetaDo.writeWord(os, 523);
        MetaDo.writeWord(os, 0);
        MetaDo.writeWord(os, 0);
        MetaDo.writeDWord(os, 5);
        MetaDo.writeWord(os, 524);
        MetaDo.writeWord(os, (int)image.getHeight());
        MetaDo.writeWord(os, (int)image.getWidth());
        MetaDo.writeDWord(os, 13 + sizeBmpWords);
        MetaDo.writeWord(os, 2881);
        MetaDo.writeDWord(os, 0xCC0020);
        MetaDo.writeWord(os, (int)image.getHeight());
        MetaDo.writeWord(os, (int)image.getWidth());
        MetaDo.writeWord(os, 0);
        MetaDo.writeWord(os, 0);
        MetaDo.writeWord(os, (int)image.getHeight());
        MetaDo.writeWord(os, (int)image.getWidth());
        MetaDo.writeWord(os, 0);
        MetaDo.writeWord(os, 0);
        os.write(data, 14, data.length - 14);
        if ((data.length & 1) == 1) {
            os.write(0);
        }
        MetaDo.writeDWord(os, 3);
        MetaDo.writeWord(os, 0);
        return os.toByteArray();
    }

    private static void writeWord(OutputStream os, int v) throws IOException {
        os.write(v & 0xFF);
        os.write(v >>> 8 & 0xFF);
    }

    private static void writeDWord(OutputStream os, int v) throws IOException {
        MetaDo.writeWord(os, v & 0xFFFF);
        MetaDo.writeWord(os, v >>> 16 & 0xFFFF);
    }
}

