/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.list;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocWriter;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.RomanList;
import com.lowagie.text.factories.RomanAlphabetFactory;
import com.lowagie.text.factories.RomanNumberFactory;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.list.RtfListItem;
import com.lowagie.text.rtf.list.RtfListLevel;
import com.lowagie.text.rtf.style.RtfFont;
import com.lowagie.text.rtf.style.RtfFontList;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidParameterException;
import java.util.ArrayList;

public class RtfList
extends RtfElement
implements RtfExtendedElement {
    public static final byte[] LIST_NUMBER = DocWriter.getISOBytes("\\ls");
    private static final byte[] LIST = DocWriter.getISOBytes("\\list");
    public static final byte[] LIST_ID = DocWriter.getISOBytes("\\listid");
    private static final byte[] LIST_TEMPLATE_ID = DocWriter.getISOBytes("\\listtemplateid");
    private static final byte[] LIST_SIMPLE = DocWriter.getISOBytes("\\listsimple");
    private static final byte[] LIST_HYBRID = DocWriter.getISOBytes("\\listhybrid");
    private static final byte[] LIST_RESTARTHDN = DocWriter.getISOBytes("\\listrestarthdn");
    private static final byte[] LIST_NAME = DocWriter.getISOBytes("\\listname");
    private static final byte[] LIST_STYLEID = DocWriter.getISOBytes("\\liststyleid");
    private static final byte[] LIST_STYLENAME = DocWriter.getISOBytes("\\liststylename");
    public static final byte[] LIST_LEVEL_NUMBER = DocWriter.getISOBytes("\\ilvl");
    public static final byte[] LIST_TEXT = DocWriter.getISOBytes("\\listtext");
    public static final byte[] LIST_NUMBER_END = DocWriter.getISOBytes(".");
    public static final byte[] TAB = DocWriter.getISOBytes("\\tab");
    private final java.util.List<RtfBasicElement> items;
    private RtfList parentList = null;
    private int listID = -1;
    public static final int LIST_TYPE_NORMAL = 0;
    public static final int LIST_TYPE_SIMPLE = 1;
    public static final int LIST_TYPE_HYBRID = 2;
    private int listType = 2;
    private String name = null;
    private int listNumber = -1;
    private final java.util.List<RtfListLevel> listLevels = new ArrayList<RtfListLevel>();

    public RtfList() {
        super(null);
        this.createDefaultLevels();
        this.items = null;
    }

    public void setDocument(RtfDocument doc) {
        this.document = doc;
        this.listNumber = this.document.getDocumentHeader().getListNumber(this);
    }

    public RtfList(RtfDocument doc) {
        super(doc);
        this.createDefaultLevels();
        this.items = null;
        this.listNumber = this.document.getDocumentHeader().getListNumber(this);
    }

    public RtfList(RtfDocument doc, List list) {
        super(doc);
        this.createDefaultLevels();
        this.items = new ArrayList<RtfBasicElement>();
        RtfListLevel ll = this.listLevels.get(0);
        this.listNumber = this.document.getDocumentHeader().getListNumber(this);
        if (list.getSymbolIndent() > 0.0f && list.getIndentationLeft() > 0.0f) {
            ll.setFirstIndent((int)((double)list.getSymbolIndent() * 20.0 * -1.0));
            ll.setLeftIndent((int)((double)(list.getIndentationLeft() + list.getSymbolIndent()) * 20.0));
        } else if (list.getSymbolIndent() > 0.0f) {
            ll.setFirstIndent((int)((double)list.getSymbolIndent() * 20.0 * -1.0));
            ll.setLeftIndent((int)((double)list.getSymbolIndent() * 20.0));
        } else if (list.getIndentationLeft() > 0.0f) {
            ll.setFirstIndent(0);
            ll.setLeftIndent((int)((double)list.getIndentationLeft() * 20.0));
        } else {
            ll.setFirstIndent(0);
            ll.setLeftIndent(0);
        }
        ll.setRightIndent((int)((double)list.getIndentationRight() * 20.0));
        ll.setSymbolIndent((int)((double)(list.getSymbolIndent() + list.getIndentationLeft()) * 20.0));
        ll.correctIndentation();
        ll.setTentative(false);
        if (list instanceof RomanList) {
            if (list.isLowercase()) {
                ll.setListType(5);
            } else {
                ll.setListType(4);
            }
        } else if (list.isNumbered()) {
            ll.setListType(1);
        } else if (list.isLettered()) {
            if (list.isLowercase()) {
                ll.setListType(3);
            } else {
                ll.setListType(2);
            }
        } else {
            ll.setBulletCharacter(list.getPreSymbol() + list.getSymbol().getContent() + list.getPostSymbol());
            ll.setListType(1023);
        }
        for (int i = 0; i < list.getItems().size(); ++i) {
            try {
                RtfBasicElement[] rtfElements;
                Element element = list.getItems().get(i);
                if (element.type() == 10) {
                    element = new ListItem((Chunk)element);
                }
                if (element instanceof ListItem) {
                    ll.setAlignment(((ListItem)element).getAlignment());
                }
                for (RtfBasicElement rtfElement : rtfElements = doc.getMapper().mapElement(element)) {
                    if (rtfElement instanceof RtfList) {
                        ((RtfList)rtfElement).setParentList(this);
                    } else if (rtfElement instanceof RtfListItem) {
                        ((RtfListItem)rtfElement).setParent(ll);
                    }
                    ll.setFontNumber(new RtfFont(this.document, new Font(2, 10.0f, 0, new Color(0, 0, 0))));
                    if (list.getSymbol() != null && list.getSymbol().getFont() != null && !list.getSymbol().getContent().startsWith("-") && list.getSymbol().getContent().length() > 0) {
                        ll.setBulletFont(list.getSymbol().getFont());
                        ll.setBulletCharacter(list.getSymbol().getContent().substring(0, 1));
                    } else if (list.getSymbol() != null && list.getSymbol().getFont() != null) {
                        ll.setBulletFont(list.getSymbol().getFont());
                    } else {
                        ll.setBulletFont(new Font(3, 10.0f, 0, new Color(0, 0, 0)));
                    }
                    this.items.add(rtfElement);
                }
                continue;
            }
            catch (DocumentException de) {
                doc.log(de);
            }
        }
    }

    @Override
    public void writeDefinition(OutputStream result) throws IOException {
        result.write(OPEN_GROUP);
        result.write(LIST);
        result.write(LIST_TEMPLATE_ID);
        result.write(RtfList.intToByteArray(this.document.getRandomInt()));
        int levelsToWrite = -1;
        switch (this.listType) {
            case 0: {
                levelsToWrite = this.listLevels.size();
                break;
            }
            case 1: {
                result.write(LIST_SIMPLE);
                result.write(RtfList.intToByteArray(1));
                levelsToWrite = 1;
                break;
            }
            case 2: {
                result.write(LIST_HYBRID);
                levelsToWrite = this.listLevels.size();
                break;
            }
        }
        this.document.outputDebugLinebreak(result);
        for (int i = 0; i < levelsToWrite; ++i) {
            this.listLevels.get(i).writeDefinition(result);
            this.document.outputDebugLinebreak(result);
        }
        result.write(LIST_ID);
        result.write(RtfList.intToByteArray(this.listID));
        result.write(CLOSE_GROUP);
        this.document.outputDebugLinebreak(result);
        if (this.items != null) {
            for (RtfBasicElement rtfElement : this.items) {
                RtfListItem rli;
                if (rtfElement instanceof RtfList) {
                    RtfList rl = (RtfList)rtfElement;
                    rl.writeDefinition(result);
                    break;
                }
                if (!(rtfElement instanceof RtfListItem) || !(rli = (RtfListItem)rtfElement).writeDefinition(result)) continue;
                break;
            }
        }
    }

    @Override
    public void writeContent(OutputStream result) throws IOException {
        if (!this.inTable) {
            result.write(OPEN_GROUP);
        }
        if (this.items != null) {
            int itemNr = 0;
            for (int i = 0; i < this.items.size(); ++i) {
                RtfElement thisRtfElement = (RtfElement)this.items.get(i);
                if (thisRtfElement instanceof RtfListItem) {
                    ++itemNr;
                    RtfListItem rtfElement = (RtfListItem)thisRtfElement;
                    RtfListLevel listLevel = rtfElement.getParent();
                    if (listLevel.getListLevel() == 0) {
                        this.correctIndentation();
                    }
                    if (i == 0) {
                        listLevel.writeListBeginning(result);
                        this.writeListNumbers(result);
                    }
                    this.writeListTextBlock(result, itemNr, listLevel);
                    rtfElement.writeContent(result);
                    if (i < this.items.size() - 1 || !this.inTable || listLevel.getListType() > 0) {
                        result.write(RtfParagraph.PARAGRAPH);
                    }
                    this.document.outputDebugLinebreak(result);
                    continue;
                }
                if (!(thisRtfElement instanceof RtfList)) continue;
                thisRtfElement.writeContent(result);
                this.writeListNumbers(result);
                this.document.outputDebugLinebreak(result);
            }
        }
        if (!this.inTable) {
            result.write(CLOSE_GROUP);
        }
        result.write(RtfParagraph.PARAGRAPH_DEFAULTS);
    }

    protected void writeListTextBlock(OutputStream result, int itemNr, RtfListLevel listLevel) throws IOException {
        result.write(OPEN_GROUP);
        result.write(LIST_TEXT);
        result.write(RtfParagraph.PARAGRAPH_DEFAULTS);
        if (this.inTable) {
            result.write(RtfParagraph.IN_TABLE);
        }
        result.write(RtfFontList.FONT_NUMBER);
        if (listLevel.getListType() != 1023) {
            result.write(RtfList.intToByteArray(listLevel.getFontNumber().getFontNumber()));
        } else {
            result.write(RtfList.intToByteArray(listLevel.getFontBullet().getFontNumber()));
        }
        listLevel.writeIndentation(result);
        result.write(DELIMITER);
        if (listLevel.getListType() != 1023) {
            switch (listLevel.getListType()) {
                case 1: {
                    result.write(RtfList.intToByteArray(itemNr));
                    break;
                }
                case 2: {
                    result.write(DocWriter.getISOBytes(RomanAlphabetFactory.getUpperCaseString(itemNr)));
                    break;
                }
                case 3: {
                    result.write(DocWriter.getISOBytes(RomanAlphabetFactory.getLowerCaseString(itemNr)));
                    break;
                }
                case 4: {
                    result.write(DocWriter.getISOBytes(RomanNumberFactory.getUpperCaseString(itemNr)));
                    break;
                }
                case 5: {
                    result.write(DocWriter.getISOBytes(RomanNumberFactory.getLowerCaseString(itemNr)));
                }
            }
            result.write(LIST_NUMBER_END);
        } else {
            this.document.filterSpecialChar(result, listLevel.getBulletCharacter(), true, false);
        }
        result.write(TAB);
        result.write(CLOSE_GROUP);
    }

    protected void writeListNumbers(OutputStream result) throws IOException {
        result.write(LIST_NUMBER);
        result.write(RtfList.intToByteArray(this.listNumber));
    }

    protected void createDefaultLevels() {
        for (int i = 0; i <= 8; ++i) {
            RtfListLevel ll = new RtfListLevel(this.document);
            ll.setListType(1);
            ll.setFirstIndent(0);
            ll.setLeftIndent(0);
            ll.setLevelTextNumber(i);
            ll.setTentative(true);
            ll.correctIndentation();
            this.listLevels.add(ll);
        }
    }

    public int getListNumber() {
        return this.listNumber;
    }

    public void setListNumber(int listNumber) {
        this.listNumber = listNumber;
    }

    @Override
    public void setInTable(boolean inTable) {
        super.setInTable(inTable);
        for (RtfBasicElement item : this.items) {
            item.setInTable(inTable);
        }
        for (RtfListLevel listLevel : this.listLevels) {
            listLevel.setInTable(inTable);
        }
    }

    @Override
    public void setInHeader(boolean inHeader) {
        super.setInHeader(inHeader);
        for (RtfBasicElement item : this.items) {
            item.setInHeader(inHeader);
        }
    }

    protected void correctIndentation() {
        for (RtfBasicElement item : this.items) {
            if (item instanceof RtfList) {
                ((RtfList)item).correctIndentation();
                continue;
            }
            if (!(item instanceof RtfListItem)) continue;
            ((RtfListItem)item).correctIndentation();
        }
    }

    public void setID(int id) {
        this.listID = id;
    }

    public int getID() {
        return this.listID;
    }

    public int getListType() {
        return this.listType;
    }

    public void setListType(int listType) throws InvalidParameterException {
        if (listType != 0 && listType != 1 && listType != 2) {
            throw new InvalidParameterException("Invalid listType value.");
        }
        this.listType = listType;
    }

    public RtfList getParentList() {
        return this.parentList;
    }

    public void setParentList(RtfList parentList) {
        this.parentList = parentList;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RtfListLevel getListLevel(int index) {
        return this.listLevels.get(index);
    }
}

