/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.list;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocWriter;
import com.lowagie.text.Font;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.list.RtfList;
import com.lowagie.text.rtf.style.RtfColor;
import com.lowagie.text.rtf.style.RtfFont;
import com.lowagie.text.rtf.style.RtfFontList;
import com.lowagie.text.rtf.style.RtfParagraphStyle;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;

public class RtfListLevel
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] LIST_LEVEL = DocWriter.getISOBytes("\\listlevel");
    private static final byte[] LIST_LEVEL_TEMPLATE_ID = DocWriter.getISOBytes("\\leveltemplateid");
    private static final byte[] LIST_LEVEL_TYPE = DocWriter.getISOBytes("\\levelnfc");
    private static final byte[] LIST_LEVEL_TYPE_NEW = DocWriter.getISOBytes("\\levelnfcn");
    private static final byte[] LIST_LEVEL_ALIGNMENT = DocWriter.getISOBytes("\\leveljc");
    private static final byte[] LIST_LEVEL_ALIGNMENT_NEW = DocWriter.getISOBytes("\\leveljcn");
    private static final byte[] LIST_LEVEL_START_AT = DocWriter.getISOBytes("\\levelstartat");
    private static final byte[] LIST_LEVEL_TEXT = DocWriter.getISOBytes("\\leveltext");
    private static final byte[] LIST_LEVEL_STYLE_NUMBERED_BEGIN = DocWriter.getISOBytes("\\'02\\'");
    private static final byte[] LIST_LEVEL_STYLE_NUMBERED_END = DocWriter.getISOBytes(".;");
    private static final byte[] LIST_LEVEL_STYLE_BULLETED_BEGIN = DocWriter.getISOBytes("\\'01");
    private static final byte[] LIST_LEVEL_STYLE_BULLETED_END = DocWriter.getISOBytes(";");
    private static final byte[] LIST_LEVEL_NUMBERS_BEGIN = DocWriter.getISOBytes("\\levelnumbers");
    private static final byte[] LIST_LEVEL_FOLOW = DocWriter.getISOBytes("\\levelfollow");
    private static final byte[] LIST_LEVEL_SPACE = DocWriter.getISOBytes("\\levelspace");
    private static final byte[] LIST_LEVEL_INDENT = DocWriter.getISOBytes("\\levelindent");
    private static final byte[] LIST_LEVEL_LEGAL = DocWriter.getISOBytes("\\levellegal");
    private static final byte[] LIST_LEVEL_NO_RESTART = DocWriter.getISOBytes("\\levelnorestart");
    private static final byte[] LIST_LEVEL_NUMBERS_NUMBERED = DocWriter.getISOBytes("\\'01");
    private static final byte[] LIST_LEVEL_NUMBERS_END = DocWriter.getISOBytes(";");
    private static final byte[] LIST_LEVEL_FIRST_INDENT = DocWriter.getISOBytes("\\fi");
    private static final byte[] LIST_LEVEL_SYMBOL_INDENT = DocWriter.getISOBytes("\\tx");
    private static final byte[] LIST_LEVEL_TENTATIVE = DocWriter.getISOBytes("\\lvltentative");
    private static final byte[] LIST_LEVEL_PICTURE = DocWriter.getISOBytes("\\levelpicture");
    public static final int LIST_TYPE_NUMBERED = 1;
    public static final int LIST_TYPE_UPPER_LETTERS = 2;
    public static final int LIST_TYPE_LOWER_LETTERS = 3;
    public static final int LIST_TYPE_UPPER_ROMAN = 4;
    public static final int LIST_TYPE_LOWER_ROMAN = 5;
    public static final int LIST_TYPE_UNKNOWN = -1;
    public static final int LIST_TYPE_BASE = 1000;
    public static final int LIST_TYPE_ARABIC = 1000;
    public static final int LIST_TYPE_UPPERCASE_ROMAN_NUMERAL = 1001;
    public static final int LIST_TYPE_LOWERCASE_ROMAN_NUMERAL = 1002;
    public static final int LIST_TYPE_UPPERCASE_LETTER = 1003;
    public static final int LIST_TYPE_LOWERCASE_LETTER = 1004;
    public static final int LIST_TYPE_ORDINAL_NUMBER = 1005;
    public static final int LIST_TYPE_CARDINAL_TEXT_NUMBER = 1006;
    public static final int LIST_TYPE_ORDINAL_TEXT_NUMBER = 1007;
    public static final int LIST_TYPE_ARABIC_LEADING_ZERO = 1022;
    public static final int LIST_TYPE_BULLET = 1023;
    public static final int LIST_TYPE_NO_NUMBER = 1255;
    private int listType = -1;
    private String bulletCharacter = "\u00b7";
    private Chunk bulletChunk = null;
    private int listStartAt = 1;
    private int listLevel = 0;
    private int firstIndent = 0;
    private int leftIndent = 0;
    private int rightIndent = 0;
    private int symbolIndent = 0;
    private boolean isTentative = true;
    private boolean isLegal = false;
    private int listNoRestart = 0;
    public static final int LIST_LEVEL_FOLLOW_TAB = 0;
    public static final int LIST_LEVEL_FOLLOW_SPACE = 1;
    public static final int LIST_LEVEL_FOLLOW_NOTHING = 2;
    private int levelFollowValue = 0;
    private int alignment = 0;
    private final int levelPicture = -1;
    private int levelTextNumber = 0;
    private RtfFont fontNumber;
    private RtfFont fontBullet;
    private final int templateID;
    private RtfListLevel listLevelParent = null;
    private RtfList parent = null;

    public RtfListLevel(RtfDocument doc) {
        super(doc);
        this.templateID = this.document.getRandomInt();
        this.setFontNumber(new RtfFont(this.document, new Font(2, 10.0f, 0, new Color(0, 0, 0))));
        this.setBulletFont(new Font(3, 10.0f, 0, new Color(0, 0, 0)));
    }

    public RtfListLevel(RtfDocument doc, RtfList parent) {
        super(doc);
        this.parent = parent;
        this.templateID = this.document.getRandomInt();
        this.setFontNumber(new RtfFont(this.document, new Font(2, 10.0f, 0, new Color(0, 0, 0))));
        this.setBulletFont(new Font(3, 10.0f, 0, new Color(0, 0, 0)));
    }

    public RtfListLevel(RtfListLevel ll) {
        super(ll.document);
        this.templateID = this.document.getRandomInt();
        this.alignment = ll.alignment;
        this.bulletCharacter = ll.bulletCharacter;
        this.firstIndent = ll.firstIndent;
        this.fontBullet = ll.fontBullet;
        this.fontNumber = ll.fontNumber;
        this.inHeader = ll.inHeader;
        this.inTable = ll.inTable;
        this.leftIndent = ll.leftIndent;
        this.listLevel = ll.listLevel;
        this.listNoRestart = ll.listNoRestart;
        this.listStartAt = ll.listStartAt;
        this.listType = ll.listType;
        this.parent = ll.parent;
        this.rightIndent = ll.rightIndent;
        this.symbolIndent = ll.symbolIndent;
    }

    public int getListNoRestart() {
        return this.listNoRestart;
    }

    public void setListNoRestart(int listNoRestart) {
        this.listNoRestart = listNoRestart;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    @Override
    public void writeDefinition(OutputStream result) throws IOException {
        result.write(OPEN_GROUP);
        result.write(LIST_LEVEL);
        result.write(LIST_LEVEL_TYPE);
        switch (this.listType) {
            case 1023: {
                result.write(RtfListLevel.intToByteArray(23));
                break;
            }
            case 1: {
                result.write(RtfListLevel.intToByteArray(0));
                break;
            }
            case 2: {
                result.write(RtfListLevel.intToByteArray(3));
                break;
            }
            case 3: {
                result.write(RtfListLevel.intToByteArray(4));
                break;
            }
            case 4: {
                result.write(RtfListLevel.intToByteArray(1));
                break;
            }
            case 5: {
                result.write(RtfListLevel.intToByteArray(2));
                break;
            }
            case 1000: {
                result.write(RtfListLevel.intToByteArray(0));
                break;
            }
            case 1001: {
                result.write(RtfListLevel.intToByteArray(1));
                break;
            }
            case 1002: {
                result.write(RtfListLevel.intToByteArray(2));
                break;
            }
            case 1003: {
                result.write(RtfListLevel.intToByteArray(3));
                break;
            }
            case 1005: {
                result.write(RtfListLevel.intToByteArray(4));
                break;
            }
            case 1006: {
                result.write(RtfListLevel.intToByteArray(5));
                break;
            }
            case 1007: {
                result.write(RtfListLevel.intToByteArray(6));
                break;
            }
            case 1004: {
                result.write(RtfListLevel.intToByteArray(7));
                break;
            }
            case 1022: {
                result.write(RtfListLevel.intToByteArray(22));
                break;
            }
            case 1255: {
                result.write(RtfListLevel.intToByteArray(255));
                break;
            }
            default: {
                if (this.listType < 1000) break;
                result.write(RtfListLevel.intToByteArray(this.listType - 1000));
            }
        }
        result.write(LIST_LEVEL_TYPE_NEW);
        switch (this.listType) {
            case 1023: {
                result.write(RtfListLevel.intToByteArray(23));
                break;
            }
            case 1: {
                result.write(RtfListLevel.intToByteArray(0));
                break;
            }
            case 2: {
                result.write(RtfListLevel.intToByteArray(3));
                break;
            }
            case 3: {
                result.write(RtfListLevel.intToByteArray(4));
                break;
            }
            case 4: {
                result.write(RtfListLevel.intToByteArray(1));
                break;
            }
            case 5: {
                result.write(RtfListLevel.intToByteArray(2));
                break;
            }
            case 1000: {
                result.write(RtfListLevel.intToByteArray(0));
                break;
            }
            case 1001: {
                result.write(RtfListLevel.intToByteArray(1));
                break;
            }
            case 1002: {
                result.write(RtfListLevel.intToByteArray(2));
                break;
            }
            case 1003: {
                result.write(RtfListLevel.intToByteArray(3));
                break;
            }
            case 1005: {
                result.write(RtfListLevel.intToByteArray(4));
                break;
            }
            case 1006: {
                result.write(RtfListLevel.intToByteArray(5));
                break;
            }
            case 1007: {
                result.write(RtfListLevel.intToByteArray(6));
                break;
            }
            case 1004: {
                result.write(RtfListLevel.intToByteArray(7));
                break;
            }
            case 1022: {
                result.write(RtfListLevel.intToByteArray(22));
                break;
            }
            case 1255: {
                result.write(RtfListLevel.intToByteArray(255));
                break;
            }
            default: {
                if (this.listType < 1000) break;
                result.write(RtfListLevel.intToByteArray(this.listType - 1000));
            }
        }
        result.write(LIST_LEVEL_ALIGNMENT);
        result.write(RtfListLevel.intToByteArray(0));
        result.write(LIST_LEVEL_ALIGNMENT_NEW);
        result.write(RtfListLevel.intToByteArray(0));
        result.write(LIST_LEVEL_FOLOW);
        result.write(RtfListLevel.intToByteArray(this.levelFollowValue));
        result.write(LIST_LEVEL_START_AT);
        result.write(RtfListLevel.intToByteArray(this.listStartAt));
        if (this.isTentative) {
            result.write(LIST_LEVEL_TENTATIVE);
        }
        if (this.isLegal) {
            result.write(LIST_LEVEL_LEGAL);
        }
        result.write(LIST_LEVEL_SPACE);
        result.write(RtfListLevel.intToByteArray(0));
        result.write(LIST_LEVEL_INDENT);
        result.write(RtfListLevel.intToByteArray(0));
        result.write(OPEN_GROUP);
        result.write(LIST_LEVEL_TEXT);
        result.write(LIST_LEVEL_TEMPLATE_ID);
        result.write(RtfListLevel.intToByteArray(this.templateID));
        if (this.listType != 1023) {
            result.write(LIST_LEVEL_STYLE_NUMBERED_BEGIN);
            if (this.levelTextNumber < 10) {
                result.write(RtfListLevel.intToByteArray(0));
            }
            result.write(RtfListLevel.intToByteArray(this.levelTextNumber));
            result.write(LIST_LEVEL_STYLE_NUMBERED_END);
        } else {
            result.write(LIST_LEVEL_STYLE_BULLETED_BEGIN);
            this.document.filterSpecialChar(result, this.bulletCharacter, false, false);
            result.write(LIST_LEVEL_STYLE_BULLETED_END);
        }
        result.write(CLOSE_GROUP);
        result.write(OPEN_GROUP);
        result.write(LIST_LEVEL_NUMBERS_BEGIN);
        if (this.listType != 1023) {
            result.write(LIST_LEVEL_NUMBERS_NUMBERED);
        }
        result.write(LIST_LEVEL_NUMBERS_END);
        result.write(CLOSE_GROUP);
        result.write(RtfFontList.FONT_NUMBER);
        if (this.listType != 1023) {
            result.write(RtfListLevel.intToByteArray(this.fontNumber.getFontNumber()));
        } else {
            result.write(RtfListLevel.intToByteArray(this.fontBullet.getFontNumber()));
        }
        result.write(DocWriter.getISOBytes("\\cf"));
        result.write(RtfListLevel.intToByteArray(this.document.getDocumentHeader().getColorNumber(new RtfColor(this.document, this.getFontNumber().getColor()))));
        this.writeIndentation(result);
        result.write(CLOSE_GROUP);
        this.document.outputDebugLinebreak(result);
    }

    @Override
    public void writeContent(OutputStream result) {
    }

    protected void writeListNumbers(OutputStream result) throws IOException {
        if (this.listLevel > 0) {
            result.write(RtfList.LIST_LEVEL_NUMBER);
            result.write(RtfListLevel.intToByteArray(this.listLevel));
        }
    }

    public void writeIndentation(OutputStream result) throws IOException {
        result.write(LIST_LEVEL_FIRST_INDENT);
        result.write(RtfListLevel.intToByteArray(this.firstIndent));
        result.write(RtfParagraphStyle.INDENT_LEFT);
        result.write(RtfListLevel.intToByteArray(this.leftIndent));
        result.write(RtfParagraphStyle.INDENT_RIGHT);
        result.write(RtfListLevel.intToByteArray(this.rightIndent));
        result.write(LIST_LEVEL_SYMBOL_INDENT);
        result.write(RtfListLevel.intToByteArray(this.leftIndent));
    }

    public void writeListBeginning(OutputStream result) throws IOException {
        result.write(RtfParagraph.PARAGRAPH_DEFAULTS);
        if (this.inTable) {
            result.write(RtfParagraph.IN_TABLE);
        }
        switch (this.alignment) {
            case 0: {
                result.write(RtfParagraphStyle.ALIGN_LEFT);
                break;
            }
            case 2: {
                result.write(RtfParagraphStyle.ALIGN_RIGHT);
                break;
            }
            case 1: {
                result.write(RtfParagraphStyle.ALIGN_CENTER);
                break;
            }
            case 3: 
            case 8: {
                result.write(RtfParagraphStyle.ALIGN_JUSTIFY);
            }
        }
        this.writeIndentation(result);
        result.write(RtfFont.FONT_SIZE);
        result.write(RtfListLevel.intToByteArray(this.fontNumber.getFontSize() * 2));
        if (this.symbolIndent > 0) {
            result.write(LIST_LEVEL_SYMBOL_INDENT);
            result.write(RtfListLevel.intToByteArray(this.leftIndent));
        }
    }

    protected void correctIndentation() {
        if (this.listLevelParent != null) {
            this.leftIndent += this.listLevelParent.getLeftIndent() + this.listLevelParent.getFirstIndent();
        }
    }

    public int getListLevel() {
        return this.listLevel;
    }

    public void setListLevel(int listLevel) {
        this.listLevel = listLevel;
    }

    public String getBulletCharacter() {
        return this.bulletCharacter;
    }

    public int getListStartAt() {
        return this.listStartAt;
    }

    public void setListStartAt(int listStartAt) {
        this.listStartAt = listStartAt;
    }

    public int getFirstIndent() {
        return this.firstIndent;
    }

    public void setFirstIndent(int firstIndent) {
        this.firstIndent = firstIndent;
    }

    public int getLeftIndent() {
        return this.leftIndent;
    }

    public void setLeftIndent(int leftIndent) {
        this.leftIndent = leftIndent;
    }

    public int getRightIndent() {
        return this.rightIndent;
    }

    public void setRightIndent(int rightIndent) {
        this.rightIndent = rightIndent;
    }

    public int getSymbolIndent() {
        return this.symbolIndent;
    }

    public void setSymbolIndent(int symbolIndent) {
        this.symbolIndent = symbolIndent;
    }

    public RtfList getParent() {
        return this.parent;
    }

    public void setParent(RtfList parent) {
        this.parent = parent;
    }

    public void setBulletCharacter(String bulletCharacter) {
        this.bulletCharacter = bulletCharacter;
    }

    public void setBulletChunk(Chunk bulletCharacter) {
        this.bulletChunk = bulletCharacter;
    }

    public int getListType() {
        return this.listType;
    }

    public void setListType(int listType) {
        this.listType = listType;
    }

    public void setBulletFont(Font f) {
        this.fontBullet = new RtfFont(this.document, f);
    }

    public RtfFont getFontNumber() {
        return this.fontNumber;
    }

    public void setFontNumber(RtfFont fontNumber) {
        this.fontNumber = fontNumber;
    }

    public RtfFont getFontBullet() {
        return this.fontBullet;
    }

    public void setFontBullet(RtfFont fontBullet) {
        this.fontBullet = fontBullet;
    }

    public boolean isTentative() {
        return this.isTentative;
    }

    public void setTentative(boolean isTentative) {
        this.isTentative = isTentative;
    }

    public boolean isLegal() {
        return this.isLegal;
    }

    public void setLegal(boolean isLegal) {
        this.isLegal = isLegal;
    }

    public int getLevelFollowValue() {
        return this.levelFollowValue;
    }

    public void setLevelFollowValue(int levelFollowValue) {
        this.levelFollowValue = levelFollowValue;
    }

    public int getLevelTextNumber() {
        return this.levelTextNumber;
    }

    public void setLevelTextNumber(int levelTextNumber) {
        this.levelTextNumber = levelTextNumber;
    }

    public RtfListLevel getListLevelParent() {
        return this.listLevelParent;
    }

    public void setListLevelParent(RtfListLevel listLevelParent) {
        this.listLevelParent = listLevelParent;
    }
}

