/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.style;

import com.lowagie.text.DocWriter;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;

public class RtfColor
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] COLOR_RED = DocWriter.getISOBytes("\\red");
    private static final byte[] COLOR_GREEN = DocWriter.getISOBytes("\\green");
    private static final byte[] COLOR_BLUE = DocWriter.getISOBytes("\\blue");
    private static final byte COLON = 59;
    private static final byte[] COLOR_NUMBER = DocWriter.getISOBytes("\\cf");
    private int colorNumber = 0;
    private final int red;
    private final int green;
    private final int blue;

    protected RtfColor(RtfDocument doc, int red, int green, int blue, int colorNumber) {
        super(doc);
        this.red = red;
        this.blue = blue;
        this.green = green;
        this.colorNumber = colorNumber;
    }

    public RtfColor(RtfDocument doc, RtfColor col) {
        super(doc);
        if (col != null) {
            this.red = col.getRed();
            this.green = col.getGreen();
            this.blue = col.getBlue();
        } else {
            this.red = 0;
            this.green = 0;
            this.blue = 0;
        }
        if (this.document != null) {
            this.colorNumber = this.document.getDocumentHeader().getColorNumber(this);
        }
    }

    public RtfColor(RtfDocument doc, Color col) {
        super(doc);
        if (col != null) {
            this.red = col.getRed();
            this.green = col.getGreen();
            this.blue = col.getBlue();
        } else {
            this.red = 0;
            this.green = 0;
            this.blue = 0;
        }
        if (this.document != null) {
            this.colorNumber = this.document.getDocumentHeader().getColorNumber(this);
        }
    }

    public RtfColor(RtfDocument doc, int red, int green, int blue) {
        super(doc);
        this.red = red;
        this.blue = blue;
        this.green = green;
        if (this.document != null) {
            this.colorNumber = this.document.getDocumentHeader().getColorNumber(this);
        }
    }

    @Override
    public void writeContent(OutputStream out) {
    }

    @Override
    public void writeDefinition(OutputStream result) throws IOException {
        result.write(COLOR_RED);
        result.write(RtfColor.intToByteArray(this.red));
        result.write(COLOR_GREEN);
        result.write(RtfColor.intToByteArray(this.green));
        result.write(COLOR_BLUE);
        result.write(RtfColor.intToByteArray(this.blue));
        result.write(59);
    }

    public void writeBegin(OutputStream result) throws IOException {
        result.write(COLOR_NUMBER);
        result.write(RtfColor.intToByteArray(this.colorNumber));
    }

    public void writeEnd(OutputStream result) {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RtfColor)) {
            return false;
        }
        RtfColor color = (RtfColor)obj;
        return this.red == color.getRed() && this.green == color.getGreen() && this.blue == color.getBlue();
    }

    public int hashCode() {
        return this.red << 16 | this.green << 8 | this.blue;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getGreen() {
        return this.green;
    }

    public int getRed() {
        return this.red;
    }

    public int getColorNumber() {
        return this.colorNumber;
    }

    @Override
    public void setRtfDocument(RtfDocument doc) {
        super.setRtfDocument(doc);
        if (this.document != null) {
            this.colorNumber = this.document.getDocumentHeader().getColorNumber(this);
        }
    }
}

