/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.style;

import com.lowagie.text.DocWriter;
import com.lowagie.text.Font;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfColor;
import com.lowagie.text.rtf.style.RtfFontList;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;

public class RtfFont
extends Font
implements RtfExtendedElement {
    private static final byte[] FONT_FAMILY = DocWriter.getISOBytes("\\froman");
    private static final byte[] FONT_CHARSET = DocWriter.getISOBytes("\\fcharset");
    public static final byte[] FONT_SIZE = DocWriter.getISOBytes("\\fs");
    private static final byte[] FONT_BOLD = DocWriter.getISOBytes("\\b");
    private static final byte[] FONT_ITALIC = DocWriter.getISOBytes("\\i");
    private static final byte[] FONT_UNDERLINE = DocWriter.getISOBytes("\\ul");
    private static final byte[] FONT_STRIKETHROUGH = DocWriter.getISOBytes("\\strike");
    private static final byte[] FONT_DOUBLE_STRIKETHROUGH = DocWriter.getISOBytes("\\striked");
    private static final byte[] FONT_SHADOW = DocWriter.getISOBytes("\\shad");
    private static final byte[] FONT_OUTLINE = DocWriter.getISOBytes("\\outl");
    private static final byte[] FONT_EMBOSSED = DocWriter.getISOBytes("\\embo");
    private static final byte[] FONT_ENGRAVED = DocWriter.getISOBytes("\\impr");
    private static final byte[] FONT_HIDDEN = DocWriter.getISOBytes("\\v");
    public static final int STYLE_NONE = 0;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_UNDERLINE = 4;
    public static final int STYLE_STRIKETHROUGH = 8;
    public static final int STYLE_DOUBLE_STRIKETHROUGH = 16;
    public static final int STYLE_SHADOW = 32;
    public static final int STYLE_OUTLINE = 64;
    public static final int STYLE_EMBOSSED = 128;
    public static final int STYLE_ENGRAVED = 256;
    public static final int STYLE_HIDDEN = 512;
    public static final String DEFAULT_FONT = "Times New Roman";
    private String fontName = "Times New Roman";
    private int fontSize = 10;
    private int fontStyle = 0;
    private int fontNumber = 0;
    private RtfColor color = null;
    private int charset = 0;
    protected RtfDocument document = null;

    public RtfFont(String fontName) {
        super(-1, -1.0f, -1, null);
        this.fontName = fontName;
    }

    public RtfFont(String fontName, float size) {
        super(-1, size, -1, null);
        this.fontName = fontName;
    }

    public RtfFont(String fontName, float size, int style) {
        super(-1, size, style, null);
        this.fontName = fontName;
    }

    public RtfFont(String fontName, float size, int style, Color color) {
        super(-1, size, style, color);
        this.fontName = fontName;
    }

    public RtfFont(String fontName, float size, int style, Color color, int charset) {
        this(fontName, size, style, color);
        this.charset = charset;
    }

    protected RtfFont(RtfDocument doc, int fontNumber) {
        this.document = doc;
        this.fontNumber = fontNumber;
        this.color = new RtfColor(doc, 0, 0, 0);
    }

    public RtfFont(RtfDocument doc, Font font) {
        this.document = doc;
        if (font != null) {
            if (font instanceof RtfFont) {
                this.fontName = ((RtfFont)font).getFontName();
                this.charset = ((RtfFont)font).getCharset();
            } else {
                this.setToDefaultFamily(font.getFamilyname());
            }
            if ("unknown".equalsIgnoreCase(this.fontName)) {
                this.fontName = DEFAULT_FONT;
            }
            this.setSize(font.getSize());
            this.setStyle(font.getStyle());
            this.setColor(font.getColor());
            if (this.document != null) {
                this.fontNumber = this.document.getDocumentHeader().getFontNumber(this);
            }
        }
        if (this.document != null) {
            this.setRtfDocument(this.document);
        }
    }

    @Override
    public void writeDefinition(OutputStream result) throws IOException {
        result.write(FONT_FAMILY);
        result.write(FONT_CHARSET);
        result.write(RtfElement.intToByteArray(this.charset));
        result.write(DELIMITER);
        this.document.filterSpecialChar(result, this.fontName, true, false);
    }

    public void writeBegin(OutputStream result) throws IOException {
        if (this.fontNumber != -1) {
            result.write(RtfFontList.FONT_NUMBER);
            result.write(RtfElement.intToByteArray(this.fontNumber));
        }
        if (this.fontSize != -1) {
            result.write(FONT_SIZE);
            result.write(RtfElement.intToByteArray(this.fontSize * 2));
        }
        if (this.fontStyle != -1) {
            if ((this.fontStyle & 1) == 1) {
                result.write(FONT_BOLD);
            }
            if ((this.fontStyle & 2) == 2) {
                result.write(FONT_ITALIC);
            }
            if ((this.fontStyle & 4) == 4) {
                result.write(FONT_UNDERLINE);
            }
            if ((this.fontStyle & 8) == 8) {
                result.write(FONT_STRIKETHROUGH);
            }
            if ((this.fontStyle & 0x200) == 512) {
                result.write(FONT_HIDDEN);
            }
            if ((this.fontStyle & 0x10) == 16) {
                result.write(FONT_DOUBLE_STRIKETHROUGH);
                result.write(RtfElement.intToByteArray(1));
            }
            if ((this.fontStyle & 0x20) == 32) {
                result.write(FONT_SHADOW);
            }
            if ((this.fontStyle & 0x40) == 64) {
                result.write(FONT_OUTLINE);
            }
            if ((this.fontStyle & 0x80) == 128) {
                result.write(FONT_EMBOSSED);
            }
            if ((this.fontStyle & 0x100) == 256) {
                result.write(FONT_ENGRAVED);
            }
        }
        if (this.color != null) {
            this.color.writeBegin(result);
        }
    }

    public void writeEnd(OutputStream result) throws IOException {
        if (this.fontStyle != -1) {
            if ((this.fontStyle & 1) == 1) {
                result.write(FONT_BOLD);
                result.write(RtfElement.intToByteArray(0));
            }
            if ((this.fontStyle & 2) == 2) {
                result.write(FONT_ITALIC);
                result.write(RtfElement.intToByteArray(0));
            }
            if ((this.fontStyle & 4) == 4) {
                result.write(FONT_UNDERLINE);
                result.write(RtfElement.intToByteArray(0));
            }
            if ((this.fontStyle & 8) == 8) {
                result.write(FONT_STRIKETHROUGH);
                result.write(RtfElement.intToByteArray(0));
            }
            if ((this.fontStyle & 0x200) == 512) {
                result.write(FONT_HIDDEN);
                result.write(RtfElement.intToByteArray(0));
            }
            if ((this.fontStyle & 0x10) == 16) {
                result.write(FONT_DOUBLE_STRIKETHROUGH);
                result.write(RtfElement.intToByteArray(0));
            }
            if ((this.fontStyle & 0x20) == 32) {
                result.write(FONT_SHADOW);
                result.write(RtfElement.intToByteArray(0));
            }
            if ((this.fontStyle & 0x40) == 64) {
                result.write(FONT_OUTLINE);
                result.write(RtfElement.intToByteArray(0));
            }
            if ((this.fontStyle & 0x80) == 128) {
                result.write(FONT_EMBOSSED);
                result.write(RtfElement.intToByteArray(0));
            }
            if ((this.fontStyle & 0x100) == 256) {
                result.write(FONT_ENGRAVED);
                result.write(RtfElement.intToByteArray(0));
            }
        }
    }

    @Override
    public void writeContent(OutputStream out) {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RtfFont)) {
            return false;
        }
        RtfFont font = (RtfFont)obj;
        return this.fontName.equals(font.getFontName());
    }

    public int hashCode() {
        return (this.fontName + this.fontSize + "-" + this.fontStyle).hashCode();
    }

    public String getFontName() {
        return this.fontName;
    }

    protected void setFontName(String fontName) {
        this.fontName = fontName;
        if (this.document != null) {
            this.fontNumber = this.document.getDocumentHeader().getFontNumber(this);
        }
    }

    @Override
    public String getFamilyname() {
        return this.fontName;
    }

    @Override
    public void setFamily(String family) {
        super.setFamily(family);
        this.setToDefaultFamily(family);
    }

    private void setToDefaultFamily(String familyname) {
        switch (Font.getFamilyIndex(familyname)) {
            case 0: {
                this.fontName = "Courier";
                break;
            }
            case 1: {
                this.fontName = "Arial";
                break;
            }
            case 3: {
                this.fontName = "Symbol";
                this.charset = 2;
                break;
            }
            case 2: {
                this.fontName = DEFAULT_FONT;
                break;
            }
            case 4: {
                this.fontName = "Windings";
                break;
            }
            default: {
                this.fontName = familyname;
            }
        }
    }

    public int getFontSize() {
        return this.fontSize;
    }

    @Override
    public void setSize(float size) {
        super.setSize(size);
        this.fontSize = (int)this.getSize();
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    @Override
    public void setStyle(int style) {
        super.setStyle(style);
        this.fontStyle = this.getStyle();
    }

    @Override
    public void setStyle(String style) {
        super.setStyle(style);
        this.fontStyle = this.getStyle();
    }

    public int getCharset() {
        return this.charset;
    }

    public void setCharset(int charset) {
        this.charset = charset;
    }

    public int getFontNumber() {
        return this.fontNumber;
    }

    @Override
    public void setRtfDocument(RtfDocument doc) {
        this.document = doc;
        if (this.document != null) {
            this.fontNumber = this.document.getDocumentHeader().getFontNumber(this);
        }
        if (this.color != null) {
            this.color.setRtfDocument(this.document);
        }
    }

    @Override
    public void setInTable(boolean inTable) {
    }

    @Override
    public void setInHeader(boolean inHeader) {
    }

    @Override
    public void setColor(Color color) {
        super.setColor(color);
        this.color = color != null ? new RtfColor(this.document, color) : null;
    }

    @Override
    public void setColor(int red, int green, int blue) {
        super.setColor(red, green, blue);
        this.color = new RtfColor(this.document, red, green, blue);
    }

    @Override
    public Font difference(Font font) {
        float dSize;
        String dFamilyname = font.getFamilyname();
        if (dFamilyname == null || "".equals(dFamilyname.trim()) || "unknown".equalsIgnoreCase(dFamilyname.trim())) {
            dFamilyname = this.fontName;
        }
        if ((dSize = font.getSize()) == -1.0f) {
            dSize = this.getSize();
        }
        int dStyle = -1;
        if (this.getStyle() != -1 && font.getStyle() != -1) {
            dStyle = this.getStyle() | font.getStyle();
        } else if (this.getStyle() != -1) {
            dStyle = this.getStyle();
        } else if (font.getStyle() != -1) {
            dStyle = font.getStyle();
        }
        Color dColor = font.getColor();
        if (dColor == null) {
            dColor = this.getColor();
        }
        int dCharset = this.charset;
        if (font instanceof RtfFont) {
            dCharset = ((RtfFont)font).getCharset();
        }
        return new RtfFont(dFamilyname, dSize, dStyle, dColor, dCharset);
    }

    @Override
    public boolean isStandardFont() {
        return false;
    }

    @Override
    public boolean same(Font that) {
        if (this == that) {
            return true;
        }
        if (that instanceof RtfFont && !Objects.equals(this.fontName, ((RtfFont)that).fontName)) {
            return false;
        }
        return super.same(that);
    }
}

