/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.table;

import com.lowagie.text.Row;
import com.lowagie.text.Table;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfFont;
import com.lowagie.text.rtf.table.RtfBorderGroup;
import com.lowagie.text.rtf.table.RtfRow;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RtfTable
extends RtfElement {
    private List<RtfRow> rows = null;
    private float tableWidthPercent = 80.0f;
    private float[] proportionalWidths = null;
    private float cellPadding = 0.0f;
    private float cellSpacing = 0.0f;
    private RtfBorderGroup borders = null;
    private int alignment = 1;
    private boolean cellsFitToPage = false;
    private boolean tableFitToPage = false;
    private int headerRows = 0;
    private int offset = -1;
    private boolean insertParagraph = true;

    public RtfTable(RtfDocument doc, Table table) {
        super(doc);
        table.complete();
        this.importTable(table);
    }

    private void importTable(Table table) {
        this.rows = new ArrayList<RtfRow>();
        this.tableWidthPercent = table.getWidth();
        this.proportionalWidths = table.getProportionalWidths();
        this.cellPadding = (float)((double)table.getPadding() * 20.0);
        this.cellSpacing = (float)((double)table.getSpacing() * 20.0);
        this.borders = new RtfBorderGroup(this.document, 1, table.getBorder(), table.getBorderWidth(), table.getBorderColor());
        this.alignment = table.getAlignment();
        int i = 0;
        Iterator<Row> rowIterator = table.iterator();
        while (rowIterator.hasNext()) {
            this.rows.add(new RtfRow(this.document, this, rowIterator.next(), i));
            ++i;
        }
        for (i = 0; i < this.rows.size(); ++i) {
            this.rows.get(i).handleCellSpanning();
            this.rows.get(i).cleanRow();
        }
        this.headerRows = table.getLastHeaderRow();
        this.cellsFitToPage = table.isCellsFitPage();
        this.tableFitToPage = table.isTableFitsPage();
        if (!Float.isNaN(table.getOffset())) {
            if (table.getOffset() < 0.0f) {
                this.insertParagraph = false;
            } else {
                this.offset = (int)(table.getOffset() * 2.0f);
            }
        }
    }

    @Override
    public void writeContent(OutputStream result) throws IOException {
        if (!this.inHeader && this.insertParagraph) {
            if (this.offset != -1) {
                result.write(RtfFont.FONT_SIZE);
                result.write(RtfTable.intToByteArray(this.offset));
            }
            result.write(RtfParagraph.PARAGRAPH);
        }
        for (RtfElement rtfElement : this.rows) {
            rtfElement.writeContent(result);
        }
        result.write(RtfParagraph.PARAGRAPH_DEFAULTS);
    }

    protected int getAlignment() {
        return this.alignment;
    }

    protected RtfBorderGroup getBorders() {
        return this.borders;
    }

    protected float getCellPadding() {
        return this.cellPadding;
    }

    protected float getCellSpacing() {
        return this.cellSpacing;
    }

    protected float[] getProportionalWidths() {
        return (float[])this.proportionalWidths.clone();
    }

    protected float getTableWidthPercent() {
        return this.tableWidthPercent;
    }

    protected List<RtfRow> getRows() {
        return this.rows;
    }

    protected boolean getCellsFitToPage() {
        return this.cellsFitToPage;
    }

    protected boolean getTableFitToPage() {
        return this.tableFitToPage;
    }

    protected int getHeaderRows() {
        return this.headerRows;
    }
}

