/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocWriter;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Footnote;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfFont;
import com.lowagie.text.rtf.style.RtfParagraphStyle;
import com.lowagie.text.rtf.text.RtfParagraph;
import com.lowagie.text.rtf.text.RtfPhrase;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;

public class RtfFootnote
extends RtfPhrase {
    private static final byte[] FOOTNOTE = DocWriter.getISOBytes("\\*\\footnote");
    private static final byte[] SUPER = DocWriter.getISOBytes("\\super");
    private static final byte[] CHFTN = DocWriter.getISOBytes("\\chftn");
    protected final RtfParagraphStyle paragraphStyle;

    public RtfFootnote(RtfDocument doc, Footnote footnote) {
        super(doc);
        RtfFont baseFont;
        if (footnote.getFont() instanceof RtfParagraphStyle) {
            this.paragraphStyle = this.document.getDocumentHeader().getRtfParagraphStyle(((RtfParagraphStyle)footnote.getFont()).getStyleName());
            baseFont = this.paragraphStyle;
        } else {
            baseFont = new RtfFont(this.document, footnote.getFont());
            this.paragraphStyle = new RtfParagraphStyle(this.document, this.document.getDocumentHeader().getRtfParagraphStyle("Normal"));
        }
        for (Element chunk : footnote) {
            if (chunk instanceof Chunk) {
                ((Chunk)chunk).setFont(baseFont.difference(((Chunk)chunk).getFont()));
            }
            try {
                RtfBasicElement[] rtfElements = doc.getMapper().mapElement(chunk);
                Collections.addAll(this.chunks, rtfElements);
            }
            catch (DocumentException documentException) {}
        }
    }

    @Override
    public void writeContent(OutputStream result) throws IOException {
        result.write(OPEN_GROUP);
        result.write(OPEN_GROUP);
        result.write(SUPER);
        result.write(CHFTN);
        result.write(OPEN_GROUP);
        result.write(FOOTNOTE);
        result.write(CHFTN);
        result.write(RtfParagraph.PARAGRAPH_DEFAULTS);
        result.write(RtfParagraph.PLAIN);
        if (this.paragraphStyle != null) {
            this.paragraphStyle.writeBegin(result);
        }
        for (RtfBasicElement rbe : this.chunks) {
            rbe.writeContent(result);
        }
        if (this.paragraphStyle != null) {
            this.paragraphStyle.writeEnd(result);
        }
        result.write(CLOSE_GROUP);
        result.write(CLOSE_GROUP);
        result.write(CLOSE_GROUP);
    }
}

