/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Section;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.field.RtfTOCEntry;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class RtfSection
extends RtfElement {
    protected RtfParagraph title = null;
    protected final List<RtfBasicElement> items = new ArrayList<RtfBasicElement>();

    public RtfSection(RtfDocument doc, Section section) {
        super(doc);
        try {
            if (section.getTitle() != null) {
                this.title = (RtfParagraph)doc.getMapper().mapElement(section.getTitle())[0];
            }
            if (this.document.getAutogenerateTOCEntries()) {
                StringBuilder titleText = new StringBuilder();
                for (Element element : section.getTitle()) {
                    if (element.type() != 10) continue;
                    titleText.append(((Chunk)element).getContent());
                }
                if (titleText.toString().trim().length() > 0) {
                    RtfTOCEntry tocEntry = new RtfTOCEntry(titleText.toString());
                    tocEntry.setRtfDocument(this.document);
                    this.items.add(tocEntry);
                }
            }
            for (Element element : section) {
                RtfBasicElement[] rtfElements;
                for (RtfBasicElement rtfElement : rtfElements = doc.getMapper().mapElement(element)) {
                    if (rtfElement == null) continue;
                    this.items.add(rtfElement);
                }
            }
            this.updateIndentation(section.getIndentationLeft(), section.getIndentationRight(), section.getIndentation());
        }
        catch (DocumentException de) {
            doc.log(de);
        }
    }

    @Override
    public void writeContent(OutputStream result) throws IOException {
        result.write(RtfParagraph.PARAGRAPH);
        if (this.title != null) {
            this.title.writeContent(result);
        }
        for (RtfBasicElement rbe : this.items) {
            rbe.writeContent(result);
        }
    }

    @Override
    public void setInTable(boolean inTable) {
        super.setInTable(inTable);
        for (RtfBasicElement rbe : this.items) {
            rbe.setInTable(inTable);
        }
    }

    @Override
    public void setInHeader(boolean inHeader) {
        super.setInHeader(inHeader);
        for (RtfBasicElement rbe : this.items) {
            rbe.setInHeader(inHeader);
        }
    }

    private void updateIndentation(float indentLeft, float indentRight, float indentContent) {
        if (this.title != null) {
            this.title.setIndentLeft((int)((double)this.title.getIndentLeft() + (double)indentLeft * 20.0));
            this.title.setIndentRight((int)((double)this.title.getIndentRight() + (double)indentRight * 20.0));
        }
        for (RtfBasicElement rtfElement : this.items) {
            if (rtfElement instanceof RtfSection) {
                ((RtfSection)rtfElement).updateIndentation(indentLeft + indentContent, indentRight, 0.0f);
                continue;
            }
            if (!(rtfElement instanceof RtfParagraph)) continue;
            ((RtfParagraph)rtfElement).setIndentLeft((int)((double)((RtfParagraph)rtfElement).getIndentLeft() + (double)(indentLeft + indentContent) * 20.0));
            ((RtfParagraph)rtfElement).setIndentRight((int)((double)((RtfParagraph)rtfElement).getIndentRight() + (double)indentRight * 20.0));
        }
    }
}

