/*
 * Decompiled with CFR 0.152.
 */
package io.github.overrun.memstack;

import io.github.overrun.memstack.MemoryStack;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.util.Arrays;

public class DefaultMemoryStack
implements MemoryStack {
    private final MemorySegment segment;
    private long[] frames;
    private Arena[] arenas;
    private long offset = 0L;
    private Arena arena;
    private int frameIndex = 0;

    public DefaultMemoryStack(MemorySegment segment, int frameCount) {
        this.segment = segment;
        this.frames = new long[frameCount];
        this.arenas = new Arena[frameCount];
    }

    private MemorySegment trySlice(long byteSize, long byteAlignment) {
        long min = this.segment.address();
        long start = (min + this.offset + byteAlignment - 1L & -byteAlignment) - min;
        MemorySegment slice = this.segment.asSlice(start, byteSize, byteAlignment);
        this.offset = start + byteSize;
        return slice;
    }

    @Override
    public MemorySegment allocate(long byteSize, long byteAlignment) {
        if (byteSize < 0L) {
            throw new IllegalArgumentException("The provided allocation size is negative: " + byteSize);
        }
        if (byteAlignment <= 0L || (byteAlignment & byteAlignment - 1L) != 0L) {
            throw new IllegalArgumentException("Invalid alignment constraint: " + byteAlignment);
        }
        return this.trySlice(byteSize, byteAlignment);
    }

    @Override
    public MemoryStack push() {
        if (this.frameIndex >= this.frames.length) {
            this.frames = Arrays.copyOf(this.frames, this.frames.length * 3 / 2);
            this.arenas = Arrays.copyOf(this.arenas, this.arenas.length * 3 / 2);
        }
        this.frames[this.frameIndex] = this.offset;
        this.arenas[this.frameIndex] = this.arena;
        ++this.frameIndex;
        return this;
    }

    @Override
    public void pop() {
        if (this.frameIndex <= 0) {
            throw new IndexOutOfBoundsException("stack frame underflow");
        }
        --this.frameIndex;
        this.offset = this.frames[this.frameIndex];
        if (this.arena != null) {
            this.arena.close();
        }
        this.arena = this.arenas[this.frameIndex];
    }

    @Override
    public int frameCount() {
        return this.frames.length;
    }

    @Override
    public int frameIndex() {
        return this.frameIndex;
    }

    @Override
    public long stackPointer() {
        return this.offset;
    }

    @Override
    public void setPointer(long pointer) {
        this.offset = pointer;
    }

    @Override
    public MemorySegment segment() {
        return this.segment;
    }

    @Override
    public Arena asArena() {
        if (this.arena == null) {
            this.arena = new Arena(){
                private final Arena arena = Arena.ofConfined();

                @Override
                public MemorySegment allocate(long byteSize, long byteAlignment) {
                    return DefaultMemoryStack.this.allocate(byteSize, byteAlignment);
                }

                @Override
                public MemorySegment.Scope scope() {
                    return this.arena.scope();
                }

                @Override
                public void close() {
                    this.arena.close();
                }
            };
        }
        return this.arena;
    }
}

