/*
 * Decompiled with CFR 0.152.
 */
package io.github.overrun.memstack;

import io.github.overrun.memstack.DefaultMemoryStack;
import io.github.overrun.memstack.StackConfigurations;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SegmentAllocator;

public interface MemoryStack
extends SegmentAllocator,
AutoCloseable {
    public static MemoryStack of(MemorySegment segment, int frameCount) {
        MemoryStack.assertWritable(segment);
        MemoryStack.checkSize(frameCount, "invalid frame count");
        return new DefaultMemoryStack(segment, frameCount);
    }

    public static MemoryStack of(long byteSize, int frameCount) {
        MemoryStack.checkSize(byteSize, "invalid stack size");
        return MemoryStack.of(Arena.ofAuto().allocate(byteSize), frameCount);
    }

    public static MemoryStack of() {
        return MemoryStack.of(StackConfigurations.STACK_SIZE.get(), (int)StackConfigurations.FRAME_COUNT.get());
    }

    public static MemoryStack ofLocal() {
        class Holder {
            static final ThreadLocal<MemoryStack> TLS = ThreadLocal.withInitial(MemoryStack::of);

            Holder() {
            }
        }
        return Holder.TLS.get();
    }

    public static MemoryStack pushLocal() {
        return MemoryStack.ofLocal().push();
    }

    public static void popLocal() {
        MemoryStack.ofLocal().pop();
    }

    private static void assertWritable(MemorySegment segment) {
        if (segment.isReadOnly()) {
            throw new IllegalArgumentException("read-only segment");
        }
    }

    private static void checkSize(long size, String message) {
        if (size <= 0L) {
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public MemorySegment allocate(long var1, long var3);

    public MemoryStack push();

    public void pop();

    @Override
    default public void close() {
        this.pop();
    }

    public int frameCount();

    public int frameIndex();

    public long stackPointer();

    public void setPointer(long var1);

    public MemorySegment segment();

    public Arena asArena();
}

