/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.builders.layout;

import io.github.palexdev.materialfx.builders.layout.PaneBuilder;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;

public class AnchorPaneBuilder
extends PaneBuilder<AnchorPane> {
    public AnchorPaneBuilder() {
        this(new AnchorPane());
    }

    public AnchorPaneBuilder(AnchorPane pane) {
        super(pane);
    }

    public static AnchorPaneBuilder anchorPane() {
        return new AnchorPaneBuilder();
    }

    public static AnchorPaneBuilder anchorPane(AnchorPane pane) {
        return new AnchorPaneBuilder(pane);
    }

    public AnchorPaneBuilder setAllConstraints(Node child, Insets constraints) {
        this.setTopAnchor(child, constraints.getTop());
        this.setRightAnchor(child, constraints.getRight());
        this.setBottomAnchor(child, constraints.getBottom());
        this.setLeftAnchor(child, constraints.getLeft());
        return this;
    }

    public AnchorPaneBuilder setTopAnchor(Node child, double top) {
        AnchorPane.setTopAnchor((Node)child, (Double)top);
        return this;
    }

    public AnchorPaneBuilder setRightAnchor(Node child, double right) {
        AnchorPane.setRightAnchor((Node)child, (Double)right);
        return this;
    }

    public AnchorPaneBuilder setBottomAnchor(Node child, double bottom) {
        AnchorPane.setBottomAnchor((Node)child, (Double)bottom);
        return this;
    }

    public AnchorPaneBuilder setLeftAnchor(Node child, double left) {
        AnchorPane.setLeftAnchor((Node)child, (Double)left);
        return this;
    }

    public AnchorPaneBuilder clearConstraints(Node child) {
        AnchorPane.clearConstraints((Node)child);
        return this;
    }
}

