/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.beans.PositionBean;
import io.github.palexdev.materialfx.beans.properties.styleable.StyleableDoubleProperty;
import io.github.palexdev.materialfx.effects.ripple.MFXCircleRippleGenerator;
import io.github.palexdev.materialfx.font.MFXFontIcon;
import io.github.palexdev.materialfx.utils.StyleablePropertiesUtils;
import java.util.List;
import java.util.function.Function;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleablePropertyFactory;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;

public class MFXIconWrapper
extends StackPane {
    private final String STYLE_CLASS = "mfx-icon-wrapper";
    private final ObjectProperty<Node> icon = new SimpleObjectProperty();
    private final MFXCircleRippleGenerator rippleGenerator = new MFXCircleRippleGenerator((Region)this);
    private final StyleableDoubleProperty size = new StyleableDoubleProperty(StyleableProperties.SIZE, (Object)this, "size", -1.0);

    public MFXIconWrapper() {
        this.initialize();
    }

    public MFXIconWrapper(Node icon, double size) {
        this.initialize();
        this.setIcon(icon);
        this.setSize(size);
    }

    public MFXIconWrapper(String description, double iconSize, double wrapperSize) {
        this.initialize();
        this.setIcon((Node)new MFXFontIcon(description, iconSize));
        this.setSize(wrapperSize);
    }

    public MFXIconWrapper(String description, double iconSize, Color iconColor, double wrapperSize) {
        this.initialize();
        this.setIcon((Node)new MFXFontIcon(description, iconSize, iconColor));
        this.setSize(wrapperSize);
    }

    public MFXIconWrapper addRippleGenerator() {
        if (!this.getChildren().contains((Object)this.rippleGenerator)) {
            super.getChildren().add(0, (Object)this.rippleGenerator);
        }
        return this;
    }

    public MFXIconWrapper defaultRippleGeneratorBehavior() {
        this.addRippleGenerator();
        this.rippleGenerator.setRipplePositionFunction(event -> PositionBean.of(event.getX(), event.getY()));
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> {
            if (event.getButton() == MouseButton.PRIMARY) {
                this.rippleGenerator.generateRipple((MouseEvent)event);
            }
        });
        return this;
    }

    public MFXIconWrapper rippleGeneratorBehavior(Function<MouseEvent, PositionBean> positionFunction) {
        this.addRippleGenerator();
        this.rippleGenerator.setRipplePositionFunction(positionFunction);
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> {
            if (event.getButton() == MouseButton.PRIMARY) {
                this.rippleGenerator.generateRipple((MouseEvent)event);
            }
        });
        return this;
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-icon-wrapper");
        this.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> this.requestFocus());
        this.icon.addListener((observable, oldValue, newValue) -> {
            super.getChildren().remove(oldValue);
            this.manageIcon((Node)newValue);
        });
        this.size.addListener((observable, oldValue, newValue) -> this.setPrefSize(newValue.doubleValue(), newValue.doubleValue()));
    }

    private void manageIcon(Node icon) {
        if (icon == null) {
            return;
        }
        ObservableList children = super.getChildren();
        if (children.isEmpty()) {
            children.add((Object)icon);
            return;
        }
        if (children.contains((Object)this.rippleGenerator)) {
            if (children.size() == 1) {
                children.add((Object)icon);
            } else {
                children.set(1, (Object)icon);
            }
        }
    }

    public ObservableList<Node> getChildren() {
        return FXCollections.unmodifiableObservableList((ObservableList)super.getChildren());
    }

    protected void layoutChildren() {
        super.layoutChildren();
        Node icon = this.getIcon();
        if (icon != null && this.getSize() == -1.0) {
            double iW = icon.prefWidth(-1.0);
            double iH = icon.prefHeight(-1.0);
            Insets padding = this.getPadding();
            double size = Math.max(padding.getLeft() + iW + padding.getRight(), padding.getTop() + iH + padding.getBottom());
            this.setSize(size);
        }
    }

    public double getSize() {
        return this.size.get();
    }

    public StyleableDoubleProperty sizeProperty() {
        return this.size;
    }

    public void setSize(double size) {
        this.size.set(size);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.cssMetaDataList;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return MFXIconWrapper.getClassCssMetaData();
    }

    public MFXCircleRippleGenerator getRippleGenerator() {
        return this.rippleGenerator;
    }

    public Node getIcon() {
        return (Node)this.icon.get();
    }

    public ObjectProperty<Node> iconProperty() {
        return this.icon;
    }

    public void setIcon(Node icon) {
        this.icon.set((Object)icon);
    }

    public void removeIcon() {
        this.setIcon(null);
    }

    private static class StyleableProperties {
        private static final StyleablePropertyFactory<MFXIconWrapper> FACTORY = new StyleablePropertyFactory(StackPane.getClassCssMetaData());
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<MFXIconWrapper, Number> SIZE;

        private StyleableProperties() {
        }

        static {
            SIZE = FACTORY.createSizeCssMetaData("-mfx-size", MFXIconWrapper::sizeProperty, (Number)-1.0);
            cssMetaDataList = StyleablePropertiesUtils.cssMetaDataList(StackPane.getClassCssMetaData(), SIZE);
        }
    }
}

