/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls.cell;

import io.github.palexdev.materialfx.MFXResourcesLoader;
import io.github.palexdev.materialfx.beans.PositionBean;
import io.github.palexdev.materialfx.controls.MFXListView;
import io.github.palexdev.materialfx.controls.cell.base.AbstractMFXListCell;
import io.github.palexdev.materialfx.effects.ripple.MFXCircleRippleGenerator;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;

public class MFXListCell<T>
extends AbstractMFXListCell<T> {
    private final String STYLE_CLASS = "mfx-list-cell";
    private final String STYLESHEET = MFXResourcesLoader.load("css/MFXListCell.css");
    protected final MFXCircleRippleGenerator rippleGenerator = new MFXCircleRippleGenerator((Region)this);
    private final Label label;

    public MFXListCell(MFXListView<T> listView, T data) {
        super(listView, data);
        if (!(data instanceof Node)) {
            this.label = new Label();
            this.label.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> listView.getConverter() != null ? listView.getConverter().toString(this.getData()) : this.getData().toString(), (Observable[])new Observable[]{this.dataProperty(), listView.converterProperty()}));
            this.label.getStyleClass().add((Object)"data-label");
        } else {
            this.label = null;
        }
        this.initialize();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.getStyleClass().add((Object)"mfx-list-cell");
        this.setupRippleGenerator();
        this.render(this.getData());
    }

    protected void setupRippleGenerator() {
        this.rippleGenerator.setManaged(false);
        this.rippleGenerator.setRipplePositionFunction(event -> PositionBean.of(event.getX(), event.getY()));
        this.rippleGenerator.rippleRadiusProperty().bind((ObservableValue)this.widthProperty().divide(2.0));
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> {
            if (event.getButton() == MouseButton.PRIMARY) {
                this.rippleGenerator.generateRipple((MouseEvent)event);
            }
        });
    }

    @Override
    protected void render(T data) {
        if (data instanceof Node) {
            this.getChildren().setAll((Object[])new Node[]{this.rippleGenerator, (Node)data});
        } else {
            this.getChildren().setAll((Object[])new Node[]{this.rippleGenerator, this.label});
        }
    }

    @Override
    public void updateItem(T item) {
        super.updateItem(item);
        if (item instanceof Node) {
            this.render(item);
        }
    }

    public Node getNode() {
        return this;
    }

    public String getUserAgentStylesheet() {
        return this.STYLESHEET;
    }

    public String toString() {
        String className = ((Object)((Object)this)).getClass().getName();
        String simpleName = className.substring(className.lastIndexOf(46) + 1);
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(simpleName);
        sb.append('@');
        sb.append(Integer.toHexString(((Object)((Object)this)).hashCode()));
        sb.append("]");
        sb.append("[Data:").append(this.getData()).append("]");
        if (this.getId() != null) {
            sb.append("[id:").append(this.getId()).append("]");
        }
        return sb.toString();
    }
}

