/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.css;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import javafx.scene.Parent;
import javafx.scene.Scene;

public class CSSFragment {
    private static final Base64.Encoder enc = Base64.getEncoder();
    private final String css;
    private String converted;
    public static final String DATA_URI_PREFIX = "data:base64,";

    public CSSFragment(String css) {
        this.css = css;
    }

    public static void applyOn(String css, Parent parent) {
        CSSFragment f = new CSSFragment(css);
        f.applyOn(parent);
    }

    public String toDataUri() {
        if (this.converted == null) {
            this.converted = DATA_URI_PREFIX + new String(enc.encode(this.css.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        }
        return this.converted;
    }

    public void applyOn(Parent parent) {
        if (!this.isAppliedOn(parent)) {
            parent.getStylesheets().add((Object)this.toDataUri());
        }
    }

    public void applyOn(Scene scene) {
        if (!this.isAppliedOn(scene)) {
            scene.getStylesheets().add((Object)this.toDataUri());
        }
    }

    public boolean isAppliedOn(Parent parent) {
        return parent.getStylesheets().contains((Object)this.toDataUri());
    }

    public boolean isAppliedOn(Scene scene) {
        return scene.getStylesheets().contains((Object)this.toDataUri());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CSSFragment that = (CSSFragment)o;
        return this.css.equals(that.css);
    }

    public int hashCode() {
        return Objects.hash(this.css);
    }

    public String toString() {
        return this.css;
    }

    public static class Builder {
        private final StringBuilder sb = new StringBuilder();

        public static Builder build() {
            return new Builder();
        }

        public Builder addSelector(String selector) {
            this.sb.append(selector).append("{\n");
            return this;
        }

        public Builder closeSelector() {
            this.sb.append("}\n\n");
            return this;
        }

        public Builder addStyle(String style) {
            this.sb.append(style).append(";\n");
            return this;
        }

        public CSSFragment toCSS() {
            if (this.sb.length() == 0) {
                throw new IllegalStateException("No styles set");
            }
            return new CSSFragment(this.sb.toString());
        }

        public void applyOn(Parent parent) {
            this.toCSS().applyOn(parent);
        }

        public void applyOn(Scene scene) {
            this.toCSS().applyOn(scene);
        }
    }
}

