/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.dialogs;

import io.github.palexdev.materialfx.dialogs.MFXGenericDialog;
import io.github.palexdev.materialfx.dialogs.MFXStageDialog;
import io.github.palexdev.materialfx.dialogs.MFXStageDialogBuilder;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;

public class MFXGenericDialogBuilder {
    private final MFXGenericDialog dialog;

    public MFXGenericDialogBuilder() {
        this.dialog = new MFXGenericDialog();
    }

    public MFXGenericDialogBuilder(MFXGenericDialog dialog) {
        this.dialog = dialog;
    }

    public static MFXGenericDialogBuilder build() {
        return new MFXGenericDialogBuilder();
    }

    public static MFXGenericDialogBuilder build(MFXGenericDialog dialog) {
        return new MFXGenericDialogBuilder(dialog);
    }

    public MFXGenericDialogBuilder setHeaderIcon(Node headerIcon) {
        this.dialog.setHeaderIcon(headerIcon);
        return this;
    }

    public MFXGenericDialogBuilder setHeaderText(String headerText) {
        this.dialog.setHeaderText(headerText);
        return this;
    }

    public MFXGenericDialogBuilder setContent(Node content) {
        this.dialog.setContent(content);
        return this;
    }

    public MFXGenericDialogBuilder setContentText(String contentText) {
        this.dialog.setContentText(contentText);
        return this;
    }

    public MFXGenericDialogBuilder setShowClose(boolean showClose) {
        this.dialog.setShowClose(showClose);
        return this;
    }

    public MFXGenericDialogBuilder setShowMinimize(boolean showMinimize) {
        this.dialog.setShowMinimize(showMinimize);
        return this;
    }

    public MFXGenericDialogBuilder setShowAlwaysOnTop(boolean showAlwaysOnTop) {
        this.dialog.setShowAlwaysOnTop(showAlwaysOnTop);
        return this;
    }

    public MFXGenericDialogBuilder setActionsOrientation(Orientation orientation) {
        this.dialog.setActionsOrientation(orientation);
        return this;
    }

    public MFXGenericDialogBuilder setOnClose(EventHandler<MouseEvent> onClose) {
        this.dialog.setOnClose(onClose);
        return this;
    }

    public MFXGenericDialogBuilder setOnMinimize(EventHandler<MouseEvent> onMinimize) {
        this.dialog.setOnMinimize(onMinimize);
        return this;
    }

    public MFXGenericDialogBuilder setOnAlwaysOnTop(EventHandler<MouseEvent> onAlwaysOnTop) {
        this.dialog.setOnAlwaysOnTop(onAlwaysOnTop);
        return this;
    }

    public MFXGenericDialogBuilder makeScrollable(boolean smoothScrolling) {
        this.dialog.buildScrollableContent(smoothScrolling);
        return this;
    }

    public MFXGenericDialogBuilder makeScrollable(Node content, boolean smoothScrolling) {
        this.dialog.buildScrollableContent(content, smoothScrolling);
        return this;
    }

    public MFXGenericDialogBuilder addStyleClasses(String ... styleClasses) {
        this.dialog.getStyleClass().addAll((Object[])styleClasses);
        return this;
    }

    public MFXGenericDialogBuilder addStylesheets(String ... stylesheets) {
        this.dialog.getStylesheets().addAll((Object[])stylesheets);
        return this;
    }

    public MFXGenericDialogBuilder addActions(Node ... actions) {
        this.dialog.addActions(actions);
        return this;
    }

    @SafeVarargs
    public final MFXGenericDialogBuilder addActions(Map.Entry<Node, EventHandler<MouseEvent>> ... actions) {
        this.dialog.addActions(actions);
        return this;
    }

    public MFXGenericDialog get() {
        return this.dialog;
    }

    public MFXStageDialogBuilder toStageDialogBuilder() {
        MFXStageDialog stageDialog = new MFXStageDialog(this.dialog);
        this.dialog.alwaysOnTopProperty().bind((ObservableValue)stageDialog.alwaysOnTopProperty());
        this.dialog.setOnAlwaysOnTop((EventHandler<MouseEvent>)((EventHandler)event -> stageDialog.setAlwaysOnTop(!this.dialog.isAlwaysOnTop())));
        this.dialog.setOnMinimize((EventHandler<MouseEvent>)((EventHandler)event -> stageDialog.setIconified(true)));
        this.dialog.setOnClose((EventHandler<MouseEvent>)((EventHandler)event -> stageDialog.close()));
        return MFXStageDialogBuilder.build(stageDialog);
    }
}

