/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.effects.ripple;

import io.github.palexdev.materialfx.beans.PositionBean;
import io.github.palexdev.materialfx.beans.properties.styleable.StyleableBooleanProperty;
import io.github.palexdev.materialfx.beans.properties.styleable.StyleableDoubleProperty;
import io.github.palexdev.materialfx.beans.properties.styleable.StyleableObjectProperty;
import io.github.palexdev.materialfx.effects.DepthLevel;
import io.github.palexdev.materialfx.effects.MFXDepthManager;
import io.github.palexdev.materialfx.effects.ripple.RippleClipType;
import io.github.palexdev.materialfx.effects.ripple.base.AbstractMFXRippleGenerator;
import io.github.palexdev.materialfx.effects.ripple.base.IRipple;
import io.github.palexdev.materialfx.factories.MFXAnimationFactory;
import io.github.palexdev.materialfx.factories.RippleClipTypeFactory;
import io.github.palexdev.materialfx.utils.AnimationUtils;
import io.github.palexdev.materialfx.utils.NodeUtils;
import io.github.palexdev.materialfx.utils.StyleablePropertiesUtils;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleablePropertyFactory;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.effect.DropShadow;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Shape;
import javafx.util.Duration;

public class MFXCircleRippleGenerator
extends AbstractMFXRippleGenerator<CircleRipple> {
    private final BooleanProperty computeRadiusMultiplier = new SimpleBooleanProperty(false);
    private final DoubleProperty radiusMultiplier = new SimpleDoubleProperty(2.0);
    private final StyleableDoubleProperty animationSpeed = new StyleableDoubleProperty(StyleableProperties.ANIMATION_SPEED, this, "animationSpeed", 1.0);
    private final StyleableBooleanProperty autoClip = new StyleableBooleanProperty(StyleableProperties.AUTO_CLIP, this, "autoClip", false);
    private final StyleableDoubleProperty backgroundOpacity = new StyleableDoubleProperty(StyleableProperties.BACKGROUND_OPACITY, this, "backgroundOpacity", 0.3);
    private final StyleableBooleanProperty paused = new StyleableBooleanProperty(StyleableProperties.PAUSED, this, "paused", false);
    private final StyleableObjectProperty<Paint> rippleColor = new StyleableObjectProperty<Color>(StyleableProperties.RIPPLE_COLOR, this, "rippleColor", Color.LIGHTGRAY);
    private final StyleableDoubleProperty rippleOpacity = new StyleableDoubleProperty(StyleableProperties.RIPPLE_OPACITY, this, "rippleOpacity", 1.0);
    private final StyleableDoubleProperty rippleRadius = new StyleableDoubleProperty(StyleableProperties.RIPPLE_RADIUS, this, "radius", 10.0);

    public MFXCircleRippleGenerator(Region region) {
        super(region);
        this.initialize();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.defaultClipSupplier();
        this.defaultPositionFunction();
        this.defaultRippleSupplier();
    }

    @Override
    public void generateRipple(MouseEvent event) {
        if (this.isPaused()) {
            return;
        }
        if (this.isCheckBounds() && !this.isWithinBounds(event)) {
            return;
        }
        if (this.getClip() != null) {
            this.setClip(null);
        }
        this.setClip(this.buildClip());
        PositionBean position = this.getRipplePositionFunction().apply(event);
        CircleRipple ripple = this.getRippleSupplier().get();
        ripple.centerXProperty().bind((ObservableValue)position.xProperty());
        ripple.centerYProperty().bind((ObservableValue)position.yProperty());
        ripple.setFill(this.getRippleColor());
        ripple.setOpacity(this.getRippleOpacity());
        Animation rippleAnimation = ripple.getAnimation();
        rippleAnimation.setRate(this.getAnimationSpeed());
        ParallelTransition transition = new ParallelTransition(new Animation[]{rippleAnimation});
        if (this.isAnimateBackground()) {
            Animation backgroundAnimation = this.getBackgroundAnimation();
            transition.getChildren().add((Object)backgroundAnimation);
        }
        if (this.isAnimateShadow()) {
            Animation shadowAnimation = this.getShadowAnimation();
            transition.getChildren().add((Object)shadowAnimation);
        }
        transition.setOnFinished(end -> this.getChildren().remove((Object)ripple));
        this.getChildren().add((Object)ripple);
        this.animationsStack.add(transition);
        transition.play();
    }

    protected Animation getBackgroundAnimation() {
        if (this.getClipSupplier() == null || this.getClipSupplier().get() == null) {
            throw new NullPointerException("RippleGenerator cannot animate background because clip supplier is null!");
        }
        Shape shape = this.getClipSupplier().get();
        shape.setFill(this.getRippleColor());
        shape.setOpacity(0.0);
        shape.opacityProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.doubleValue() == 0.0) {
                this.getChildren().remove((Object)shape);
            }
        });
        return AnimationUtils.TimelineBuilder.build().add(AnimationUtils.KeyFrames.of(Duration.ZERO, (EventHandler<ActionEvent>)((EventHandler)event -> this.getChildren().add(0, (Object)shape))), AnimationUtils.KeyFrames.of(Duration.millis((double)300.0), shape.opacityProperty(), Double.valueOf(this.getBackgroundOpacity())), AnimationUtils.KeyFrames.of(Duration.millis((double)450.0), shape.opacityProperty(), Integer.valueOf(0), Interpolator.LINEAR)).getAnimation();
    }

    protected Animation getShadowAnimation() {
        DropShadow shadowEffect;
        DepthLevel level;
        Timeline animation = new Timeline();
        if (this.region.getEffect() != null && this.region.getEffect() instanceof DropShadow && (level = DepthLevel.from(shadowEffect = (DropShadow)this.region.getEffect())) != null) {
            DropShadow startShadow = MFXDepthManager.shadowOf(level);
            DropShadow endShadow = MFXDepthManager.shadowOf(level, this.getDepthLevelOffset());
            KeyValue keyValue5 = new KeyValue((WritableValue)shadowEffect.spreadProperty(), (Object)endShadow.getSpread());
            KeyValue keyValue6 = new KeyValue((WritableValue)shadowEffect.spreadProperty(), (Object)startShadow.getSpread());
            KeyValue keyValue7 = new KeyValue((WritableValue)shadowEffect.radiusProperty(), (Object)endShadow.getRadius());
            KeyValue keyValue8 = new KeyValue((WritableValue)shadowEffect.radiusProperty(), (Object)startShadow.getRadius());
            KeyValue keyValue9 = new KeyValue((WritableValue)shadowEffect.offsetXProperty(), (Object)endShadow.getOffsetX());
            KeyValue keyValue10 = new KeyValue((WritableValue)shadowEffect.offsetXProperty(), (Object)startShadow.getOffsetX());
            KeyValue keyValue11 = new KeyValue((WritableValue)shadowEffect.offsetYProperty(), (Object)endShadow.getOffsetY());
            KeyValue keyValue12 = new KeyValue((WritableValue)shadowEffect.offsetYProperty(), (Object)startShadow.getOffsetY());
            KeyFrame keyFrame5 = new KeyFrame(Duration.millis((double)350.0), new KeyValue[]{keyValue5, keyValue7, keyValue9, keyValue11});
            KeyFrame keyFrame6 = new KeyFrame(Duration.millis((double)700.0), new KeyValue[]{keyValue6, keyValue8, keyValue10, keyValue12});
            animation.getKeyFrames().setAll((Object[])new KeyFrame[]{keyFrame5, keyFrame6});
        }
        return animation;
    }

    protected double computeRadiusMultiplier(double xCoordinate) {
        Bounds bounds = this.region.getLayoutBounds();
        double distanceFromMax = Math.abs(bounds.getMaxX() - xCoordinate);
        double nearestBound = distanceFromMax < xCoordinate ? 0.0 : bounds.getMaxX();
        double finalRadius = this.getRippleRadius() + Math.abs(xCoordinate - nearestBound);
        return finalRadius / this.getRippleRadius();
    }

    protected Node buildClip() {
        if (this.isAutoClip()) {
            CornerRadii radius = NodeUtils.parseCornerRadius(this.region);
            Region clip = new Region();
            clip.resizeRelocate(0.0, 0.0, this.region.getWidth(), this.region.getHeight());
            NodeUtils.setBackground(clip, (Paint)Color.WHITE, radius);
            return clip;
        }
        return (Node)this.getClipSupplier().get();
    }

    public boolean isComputeRadiusMultiplier() {
        return this.computeRadiusMultiplier.get();
    }

    public BooleanProperty computeRadiusMultiplierProperty() {
        return this.computeRadiusMultiplier;
    }

    public void setComputeRadiusMultiplier(boolean computeRadiusMultiplier) {
        this.computeRadiusMultiplier.set(computeRadiusMultiplier);
    }

    public double getRadiusMultiplier() {
        return this.radiusMultiplier.get();
    }

    public DoubleProperty radiusMultiplierProperty() {
        return this.radiusMultiplier;
    }

    public void setRadiusMultiplier(double radiusMultiplier) {
        this.radiusMultiplier.set(radiusMultiplier);
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    @Override
    public void defaultClipSupplier() {
        this.setClipSupplier(() -> new RippleClipTypeFactory(RippleClipType.RECTANGLE).build(this.region));
    }

    @Override
    public Supplier<Shape> getClipSupplier() {
        return this.clipSupplier;
    }

    @Override
    public void setClipSupplier(Supplier<Shape> clipSupplier) {
        this.clipSupplier = clipSupplier;
    }

    @Override
    public void defaultPositionFunction() {
        this.setRipplePositionFunction(event -> new PositionBean());
    }

    @Override
    public Function<MouseEvent, PositionBean> getRipplePositionFunction() {
        return this.positionFunction;
    }

    @Override
    public void setRipplePositionFunction(Function<MouseEvent, PositionBean> positionFunction) {
        this.positionFunction = positionFunction;
    }

    @Override
    public void defaultRippleSupplier() {
        this.setRippleSupplier(() -> new CircleRipple());
    }

    @Override
    public Supplier<CircleRipple> getRippleSupplier() {
        return this.rippleSupplier;
    }

    @Override
    public void setRippleSupplier(Supplier<CircleRipple> rippleSupplier) {
        this.rippleSupplier = rippleSupplier;
    }

    public double getAnimationSpeed() {
        return this.animationSpeed.get();
    }

    public StyleableDoubleProperty animationSpeedProperty() {
        return this.animationSpeed;
    }

    public void setAnimationSpeed(double animationSpeed) {
        this.animationSpeed.set(animationSpeed);
    }

    public boolean isAutoClip() {
        return this.autoClip.get();
    }

    public StyleableBooleanProperty autoClipProperty() {
        return this.autoClip;
    }

    public void setAutoClip(boolean autoClip) {
        this.autoClip.set(autoClip);
    }

    public double getBackgroundOpacity() {
        return this.backgroundOpacity.get();
    }

    public StyleableDoubleProperty backgroundOpacityProperty() {
        return this.backgroundOpacity;
    }

    public void setBackgroundOpacity(double backgroundOpacity) {
        this.backgroundOpacity.set(backgroundOpacity);
    }

    public boolean isPaused() {
        return this.paused.get();
    }

    public StyleableBooleanProperty pausedProperty() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused.set(paused);
    }

    public Paint getRippleColor() {
        return (Paint)this.rippleColor.get();
    }

    public StyleableObjectProperty<Paint> rippleColorProperty() {
        return this.rippleColor;
    }

    public void setRippleColor(Paint rippleColor) {
        this.rippleColor.set(rippleColor);
    }

    public double getRippleOpacity() {
        return this.rippleOpacity.get();
    }

    public StyleableDoubleProperty rippleOpacityProperty() {
        return this.rippleOpacity;
    }

    public void setRippleOpacity(double rippleOpacity) {
        this.rippleOpacity.set(rippleOpacity);
    }

    public double getRippleRadius() {
        return this.rippleRadius.get();
    }

    public StyleableDoubleProperty rippleRadiusProperty() {
        return this.rippleRadius;
    }

    public void setRippleRadius(double radius) {
        this.rippleRadius.set(radius);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getControlCssMetaDataList() {
        return StyleableProperties.cssMetaDataList;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return MFXCircleRippleGenerator.getControlCssMetaDataList();
    }

    private static class StyleableProperties {
        private static final StyleablePropertyFactory<MFXCircleRippleGenerator> FACTORY = new StyleablePropertyFactory(AbstractMFXRippleGenerator.getClassCssMetaData());
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<MFXCircleRippleGenerator, Number> ANIMATION_SPEED;
        private static final CssMetaData<MFXCircleRippleGenerator, Boolean> AUTO_CLIP;
        private static final CssMetaData<MFXCircleRippleGenerator, Number> BACKGROUND_OPACITY;
        private static final CssMetaData<MFXCircleRippleGenerator, Paint> RIPPLE_COLOR;
        private static final CssMetaData<MFXCircleRippleGenerator, Number> RIPPLE_OPACITY;
        private static final CssMetaData<MFXCircleRippleGenerator, Number> RIPPLE_RADIUS;
        private static final CssMetaData<MFXCircleRippleGenerator, Boolean> PAUSED;

        private StyleableProperties() {
        }

        static {
            ANIMATION_SPEED = FACTORY.createSizeCssMetaData("-mfx-animation-speed", MFXCircleRippleGenerator::animationSpeedProperty, (Number)1.0);
            AUTO_CLIP = FACTORY.createBooleanCssMetaData("-mfx-auto-clip", MFXCircleRippleGenerator::autoClipProperty, false);
            BACKGROUND_OPACITY = FACTORY.createSizeCssMetaData("-mfx-background-opacity", MFXCircleRippleGenerator::backgroundOpacityProperty, (Number)0.3);
            RIPPLE_COLOR = FACTORY.createPaintCssMetaData("-mfx-ripple-color", MFXCircleRippleGenerator::rippleColorProperty, (Paint)Color.LIGHTGRAY);
            RIPPLE_OPACITY = FACTORY.createSizeCssMetaData("-mfx-ripple-opacity", MFXCircleRippleGenerator::rippleOpacityProperty, (Number)1.0);
            RIPPLE_RADIUS = FACTORY.createSizeCssMetaData("-mfx-ripple-radius", MFXCircleRippleGenerator::rippleRadiusProperty, (Number)10.0);
            PAUSED = FACTORY.createBooleanCssMetaData("-mfx-paused", MFXCircleRippleGenerator::pausedProperty, false);
            cssMetaDataList = StyleablePropertiesUtils.cssMetaDataList(AbstractMFXRippleGenerator.getClassCssMetaData(), ANIMATION_SPEED, AUTO_CLIP, BACKGROUND_OPACITY, PAUSED, RIPPLE_COLOR, RIPPLE_OPACITY, RIPPLE_RADIUS);
        }
    }

    public class CircleRipple
    extends Circle
    implements IRipple {
        private double xPosition = -1.0;

        public CircleRipple() {
            this.setRadius(0.0);
        }

        @Override
        public Animation getAnimation() {
            double mul = MFXCircleRippleGenerator.this.getRadiusMultiplier();
            if (MFXCircleRippleGenerator.this.isComputeRadiusMultiplier()) {
                mul = MFXCircleRippleGenerator.this.computeRadiusMultiplier(this.xPosition);
            }
            return AnimationUtils.TimelineBuilder.build().add(AnimationUtils.KeyFrames.of(150.0, this.radiusProperty(), Double.valueOf(MFXCircleRippleGenerator.this.getRippleRadius())), AnimationUtils.KeyFrames.of(400.0, this.radiusProperty(), Double.valueOf(MFXCircleRippleGenerator.this.getRippleRadius() * mul)), AnimationUtils.KeyFrames.of(1200.0, this.opacityProperty(), Integer.valueOf(0), MFXAnimationFactory.INTERPOLATOR_V2), AnimationUtils.KeyFrames.of(500.0, (EventHandler<ActionEvent>)((EventHandler)event -> MFXCircleRippleGenerator.this.animationsStack.pop()))).getAnimation();
        }

        public void setXPosition(double xPosition) {
            this.xPosition = xPosition;
        }
    }
}

