/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.controls.MFXButton;
import io.github.palexdev.materialfx.effects.MFXDepthManager;
import io.github.palexdev.materialfx.effects.ripple.MFXCircleRippleGenerator;
import javafx.scene.control.Button;
import javafx.scene.control.skin.ButtonSkin;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseEvent;

public class MFXButtonSkin
extends ButtonSkin {
    public MFXButtonSkin(MFXButton button) {
        super((Button)button);
        this.setListeners();
        this.updateButtonType();
        this.updateChildren();
    }

    private void setListeners() {
        MFXButton button = (MFXButton)this.getSkinnable();
        MFXCircleRippleGenerator rippleGenerator = button.getRippleGenerator();
        button.depthLevelProperty().addListener((observable, oldValue, newValue) -> this.updateButtonType());
        button.buttonTypeProperty().addListener((observable, oldValue, newValue) -> this.updateButtonType());
        button.addEventFilter(MouseEvent.MOUSE_PRESSED, rippleGenerator::generateRipple);
    }

    private void updateButtonType() {
        MFXButton button = (MFXButton)this.getSkinnable();
        switch (button.getButtonType()) {
            case RAISED: {
                button.setEffect((Effect)MFXDepthManager.shadowOf(button.getDepthLevel()));
                button.setPickOnBounds(false);
                break;
            }
            case FLAT: {
                button.setPickOnBounds(true);
            }
        }
    }

    protected void updateChildren() {
        super.updateChildren();
        MFXButton button = (MFXButton)this.getSkinnable();
        if (!this.getChildren().contains((Object)button.getRippleGenerator())) {
            this.getChildren().add(0, (Object)button.getRippleGenerator());
        }
    }
}

