/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.collections.TransformableList;
import io.github.palexdev.materialfx.controls.BoundTextField;
import io.github.palexdev.materialfx.controls.MFXComboBox;
import io.github.palexdev.materialfx.controls.MFXFilterComboBox;
import io.github.palexdev.materialfx.controls.MFXTextField;
import io.github.palexdev.materialfx.i18n.I18N;
import io.github.palexdev.materialfx.skins.MFXComboBoxSkin;
import io.github.palexdev.virtualizedfx.flow.simple.SimpleVirtualFlow;
import java.util.function.Function;
import java.util.function.Predicate;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;

public class MFXFilterComboBoxSkin<T>
extends MFXComboBoxSkin<T> {
    public MFXFilterComboBoxSkin(MFXFilterComboBox<T> comboBox, BoundTextField boundField) {
        super(comboBox, boundField);
        this.addListeners();
    }

    private void addListeners() {
        MFXComboBox comboBox = this.getComboBox();
        ((MFXFilterComboBox)comboBox).searchTextProperty().addListener((observable, oldValue, newValue) -> this.filter((String)newValue));
        this.popup.showingProperty().addListener((arg_0, arg_1, arg_2) -> MFXFilterComboBoxSkin.lambda$addListeners$1((MFXFilterComboBox)comboBox, arg_0, arg_1, arg_2));
    }

    protected void filter(String text) {
        MFXComboBox comboBox = this.getComboBox();
        Function<String, Predicate<String>> filterFunction = ((MFXFilterComboBox)comboBox).getFilterFunction();
        if (filterFunction == null) {
            return;
        }
        Predicate filter = filterFunction.apply(text);
        ((MFXFilterComboBox)comboBox).getFilterList().setPredicate(filter);
    }

    @Override
    protected Node createPopupContent() {
        MFXComboBox comboBox = this.getComboBox();
        TransformableList filterList = ((MFXFilterComboBox)comboBox).getFilterList();
        MFXTextField searchField = new MFXTextField("", I18N.getOrDefault("filterCombo.search", new Object[0]), (MFXFilterComboBox)comboBox){
            final /* synthetic */ MFXFilterComboBox val$comboBox;
            {
                this.val$comboBox = mFXFilterComboBox;
                super(text, promptText);
            }

            @Override
            public String getUserAgentStylesheet() {
                return this.val$comboBox.getUserAgentStylesheet();
            }
        };
        searchField.getStyleClass().add((Object)"search-field");
        searchField.textProperty().bindBidirectional((Property)((MFXFilterComboBox)comboBox).searchTextProperty());
        searchField.setMaxWidth(Double.MAX_VALUE);
        SimpleVirtualFlow virtualFlow = new SimpleVirtualFlow(filterList, comboBox.getCellFactory(), Orientation.VERTICAL);
        virtualFlow.cellFactoryProperty().bind(comboBox.cellFactoryProperty());
        virtualFlow.prefWidthProperty().bind((ObservableValue)comboBox.widthProperty());
        virtualFlow.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (this.popup.isShowing()) {
                this.popup.hide();
            }
        });
        VBox container = new VBox(10.0, new Node[]{searchField, virtualFlow});
        container.getStyleClass().add((Object)"search-container");
        container.setAlignment(Pos.TOP_CENTER);
        return container;
    }

    @Override
    public MFXFilterComboBox<T> getComboBox() {
        return (MFXFilterComboBox)this.getSkinnable();
    }

    private static /* synthetic */ void lambda$addListeners$1(MFXFilterComboBox comboBox, ObservableValue observable, Boolean oldValue, Boolean newValue) {
        if (!newValue.booleanValue() && comboBox.isResetOnPopupHidden()) {
            comboBox.setSearchText("");
        }
    }
}

