/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.beans.BiPredicateBean;
import io.github.palexdev.materialfx.beans.FilterBean;
import io.github.palexdev.materialfx.controls.MFXButton;
import io.github.palexdev.materialfx.controls.MFXComboBox;
import io.github.palexdev.materialfx.controls.MFXFilterPane;
import io.github.palexdev.materialfx.controls.MFXIconWrapper;
import io.github.palexdev.materialfx.controls.MFXScrollPane;
import io.github.palexdev.materialfx.controls.MFXTextField;
import io.github.palexdev.materialfx.controls.base.MFXCombo;
import io.github.palexdev.materialfx.controls.cell.MFXComboBoxCell;
import io.github.palexdev.materialfx.dialogs.MFXDialogs;
import io.github.palexdev.materialfx.dialogs.MFXGenericDialog;
import io.github.palexdev.materialfx.dialogs.MFXGenericDialogBuilder;
import io.github.palexdev.materialfx.dialogs.MFXStageDialog;
import io.github.palexdev.materialfx.effects.ripple.RippleClipType;
import io.github.palexdev.materialfx.enums.ChainMode;
import io.github.palexdev.materialfx.enums.FloatMode;
import io.github.palexdev.materialfx.factories.InsetsFactory;
import io.github.palexdev.materialfx.factories.RippleClipTypeFactory;
import io.github.palexdev.materialfx.filter.BooleanFilter;
import io.github.palexdev.materialfx.filter.EnumFilter;
import io.github.palexdev.materialfx.filter.base.AbstractFilter;
import io.github.palexdev.materialfx.filter.base.NumberFilter;
import io.github.palexdev.materialfx.font.MFXFontIcon;
import io.github.palexdev.materialfx.i18n.I18N;
import io.github.palexdev.materialfx.utils.NodeUtils;
import java.util.Collection;
import javafx.beans.property.ListProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.Modality;

public class MFXFilterPaneSkin<T>
extends SkinBase<MFXFilterPane<T>> {
    private final VBox container;
    private final Region filterBuilder;
    private final MFXScrollPane filtersContainer;
    private final FlowPane activeFiltersPane;
    private final MFXGenericDialog dialogContent;
    private final MFXStageDialog dialog;
    private final StringProperty query = new SimpleStringProperty();
    private boolean avoidQueryReset = false;

    public MFXFilterPaneSkin(final MFXFilterPane<T> filterPane) {
        super(filterPane);
        this.dialogContent = MFXDialogs.error().setShowAlwaysOnTop(false).setShowMinimize(false).get();
        this.dialog = MFXGenericDialogBuilder.build(this.dialogContent).toStageDialogBuilder().initOwner(filterPane.getScene().getWindow()).initModality(Modality.WINDOW_MODAL).get();
        Region header = this.buildHeader();
        Label filtersLabel = new Label(I18N.getOrDefault("filterPane.activeFilters", new Object[0]));
        filtersLabel.getStyleClass().add((Object)"header-label");
        VBox.setMargin((Node)filtersLabel, (Insets)InsetsFactory.top(15.0));
        this.filterBuilder = this.buildFilterBuilder();
        this.activeFiltersPane = this.buildActiveFilters();
        this.filtersContainer = new MFXScrollPane((Node)this.activeFiltersPane){

            @Override
            public String getUserAgentStylesheet() {
                return filterPane.getUserAgentStylesheet();
            }
        };
        this.filtersContainer.setFitToWidth(true);
        this.filtersContainer.maxWidthProperty().bind((ObservableValue)filterPane.widthProperty());
        this.container = new VBox(10.0, new Node[]{header, this.filterBuilder, filtersLabel, this.filtersContainer});
        this.getChildren().setAll((Object[])new Node[]{this.container});
        this.addListeners();
    }

    private void addListeners() {
        MFXFilterPane filterPane = (MFXFilterPane)this.getSkinnable();
        filterPane.getActiveFilters().addListener(invalidated -> this.updateFilters());
    }

    protected void updateFilters() {
        MFXFilterPane filterPane = (MFXFilterPane)this.getSkinnable();
        ObservableList filters = filterPane.getActiveFilters();
        ObservableList children = FXCollections.observableArrayList();
        for (int i = 0; i < filters.size(); ++i) {
            FilterBean filter;
            int previous = i - 1;
            if (previous >= 0) {
                filter = (FilterBean)filters.get(previous);
                children.add((Object)this.buildAndOrIcon(filter));
            }
            filter = (FilterBean)filters.get(i);
            children.add((Object)this.buildFilter(filter));
        }
        this.activeFiltersPane.getChildren().setAll((Collection)children);
    }

    protected Region buildFilter(FilterBean<T, ?> filter) {
        Label filterLabel = new Label(filter.getFilterName());
        Label functionLabel = new Label(filter.getPredicateName());
        Label queryLabel = new Label(filter.getQuery());
        functionLabel.getStyleClass().add((Object)"function-text");
        MFXFontIcon remove = new MFXFontIcon("mfx-x-alt", 12.0);
        remove.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> ((MFXFilterPane)this.getSkinnable()).getActiveFilters().remove((Object)filter));
        HBox.setMargin((Node)remove, (Insets)InsetsFactory.top(2.0));
        HBox container = new HBox(15.0, new Node[]{filterLabel, functionLabel, queryLabel, remove});
        container.getStyleClass().add((Object)"active-filter");
        container.setAlignment(Pos.CENTER);
        return container;
    }

    protected Node buildAndOrIcon(FilterBean<T, ?> filter) {
        Text modeText = new Text(filter.getMode().text());
        modeText.getStyleClass().add((Object)"and-or-text");
        modeText.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (filter.getMode() == ChainMode.AND) {
                filter.setMode(ChainMode.OR);
                modeText.setText(ChainMode.OR.text());
            } else {
                filter.setMode(ChainMode.AND);
                modeText.setText(ChainMode.AND.text());
            }
        });
        return modeText;
    }

    protected Region buildHeader() {
        MFXFilterPane filterPane = (MFXFilterPane)this.getSkinnable();
        Label headerLabel = new Label();
        headerLabel.getStyleClass().add((Object)"header-label");
        headerLabel.textProperty().bind((ObservableValue)filterPane.headerTextProperty());
        headerLabel.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)headerLabel, (Priority)Priority.ALWAYS);
        MFXIconWrapper filter = new MFXIconWrapper("mfx-variant7-mark", 16.0, 28.0).defaultRippleGeneratorBehavior();
        MFXIconWrapper reset = new MFXIconWrapper("mfx-undo", 16.0, 28.0).defaultRippleGeneratorBehavior();
        filter.setId("filterIcon");
        reset.setId("resetIcon");
        NodeUtils.makeRegionCircular((Region)filter);
        NodeUtils.makeRegionCircular((Region)reset);
        filter.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> filterPane.getOnFilter().handle(event));
        reset.addEventHandler(MouseEvent.MOUSE_CLICKED, this::reset);
        HBox box = new HBox(5.0, new Node[]{headerLabel, filter, reset});
        box.setAlignment(Pos.CENTER_LEFT);
        box.getStyleClass().add((Object)"header");
        return box;
    }

    protected Region buildFilterBuilder() {
        final MFXFilterPane filterPane = (MFXFilterPane)this.getSkinnable();
        SimpleListProperty predicates = new SimpleListProperty(FXCollections.observableArrayList());
        final MFXTextField searchField = new MFXTextField(){

            @Override
            public String getUserAgentStylesheet() {
                return filterPane.getUserAgentStylesheet();
            }
        };
        searchField.setFloatMode(FloatMode.DISABLED);
        searchField.setPromptText(I18N.getOrDefault("filterPane.searchField", new Object[0]));
        searchField.textProperty().bindBidirectional((Property)this.query);
        final MFXComboBox<Object> enumsCombo = new MFXComboBox<Object>(){

            @Override
            public String getUserAgentStylesheet() {
                return filterPane.getUserAgentStylesheet();
            }
        };
        enumsCombo.setFloatMode(FloatMode.DISABLED);
        enumsCombo.valueProperty().addListener((observable, oldValue, newValue) -> this.setQuery(newValue.toString()));
        enumsCombo.setManaged(false);
        enumsCombo.setVisible(false);
        enumsCombo.setCellFactory(t -> new MFXComboBoxCell<Object>((MFXCombo)enumsCombo, t){

            @Override
            public String getUserAgentStylesheet() {
                return filterPane.getUserAgentStylesheet();
            }
        });
        final MFXComboBox<Boolean> booleansCombo = new MFXComboBox<Boolean>(FXCollections.observableArrayList((Object[])new Boolean[]{true, false})){

            @Override
            public String getUserAgentStylesheet() {
                return filterPane.getUserAgentStylesheet();
            }
        };
        booleansCombo.setFloatMode(FloatMode.DISABLED);
        booleansCombo.valueProperty().addListener((observable, oldValue, newValue) -> this.setQuery(newValue.toString()));
        booleansCombo.setManaged(false);
        booleansCombo.setVisible(false);
        booleansCombo.setCellFactory(t -> new MFXComboBoxCell<Boolean>((MFXCombo)booleansCombo, t){

            @Override
            public String getUserAgentStylesheet() {
                return filterPane.getUserAgentStylesheet();
            }
        });
        MFXComboBox predicatesCombo = new MFXComboBox<BiPredicateBean<?, ?>>((ObservableList)predicates){

            @Override
            public String getUserAgentStylesheet() {
                return filterPane.getUserAgentStylesheet();
            }
        };
        predicatesCombo.setFloatMode(FloatMode.DISABLED);
        predicatesCombo.getStyleClass().add((Object)"predicates-combo");
        predicatesCombo.setCellFactory(p -> new MFXComboBoxCell<BiPredicateBean<?, ?>>(predicatesCombo, (BiPredicateBean)p){

            @Override
            public String getUserAgentStylesheet() {
                return filterPane.getUserAgentStylesheet();
            }
        });
        MFXComboBox filterCombo = new MFXComboBox<AbstractFilter<T, ?>>(filterPane.getFilters()){

            @Override
            public String getUserAgentStylesheet() {
                return filterPane.getUserAgentStylesheet();
            }
        };
        filterCombo.setFloatMode(FloatMode.DISABLED);
        filterCombo.getStyleClass().add((Object)"filter-combo");
        filterCombo.valueProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$buildFilterBuilder$9(predicatesCombo, (ListProperty)predicates, filterCombo, enumsCombo, booleansCombo, searchField, arg_0, arg_1, arg_2));
        filterCombo.selectFirst();
        filterCombo.setCellFactory(t -> new MFXComboBoxCell<AbstractFilter<T, ?>>(filterCombo, (AbstractFilter)t){

            @Override
            public String getUserAgentStylesheet() {
                return filterPane.getUserAgentStylesheet();
            }
        });
        MFXButton addButton = new MFXButton(I18N.getOrDefault("filterPane.addFilter", new Object[0])){

            @Override
            public String getUserAgentStylesheet() {
                return filterPane.getUserAgentStylesheet();
            }
        };
        addButton.setOnAction(event -> {
            if (filterCombo.getSelectedItem() != null && predicatesCombo.getSelectedItem() != null && !searchField.getText().isEmpty()) {
                AbstractFilter selected = (AbstractFilter)filterCombo.getValue();
                selected.setSelectedPredicateIndex(predicatesCombo.getSelectedIndex());
                FilterBean predicate = selected.toFilterBean(this.getQuery());
                if (this.queryValidation(selected)) {
                    filterPane.getActiveFilters().add(predicate);
                }
            }
        });
        addButton.getRippleGenerator().setClipSupplier(() -> new RippleClipTypeFactory(RippleClipType.ROUNDED_RECTANGLE).setArcs(30.0).build((Region)addButton));
        HBox container = new HBox(10.0, new Node[]{filterCombo, predicatesCombo, searchField, enumsCombo, booleansCombo, addButton}){

            protected void layoutChildren() {
                super.layoutChildren();
                double w = searchField.getBoundsInParent().getWidth();
                double h = searchField.getBoundsInParent().getHeight();
                double x = searchField.getBoundsInParent().getMinX();
                double y = searchField.getBoundsInParent().getMinY();
                enumsCombo.resizeRelocate(x, y, w, h);
                booleansCombo.resizeRelocate(x, y, w, h);
            }
        };
        container.setAlignment(Pos.CENTER_LEFT);
        return container;
    }

    protected FlowPane buildActiveFilters() {
        MFXFilterPane filterPane = (MFXFilterPane)this.getSkinnable();
        FlowPane flowPane = new FlowPane(Orientation.HORIZONTAL, 10.0, 10.0);
        flowPane.setAlignment(Pos.TOP_LEFT);
        flowPane.prefWrapLengthProperty().bind((ObservableValue)filterPane.widthProperty());
        flowPane.setPadding(InsetsFactory.bottom(7.0));
        return flowPane;
    }

    protected boolean queryValidation(AbstractFilter<T, ?> filter) {
        String name = "";
        try {
            if (filter instanceof NumberFilter) {
                NumberFilter numberFilter = (NumberFilter)filter;
                name = numberFilter.name();
                Number number = (Number)numberFilter.getValue(this.getQuery());
            }
            return true;
        }
        catch (Exception ex) {
            String title = "Failed to parse: " + name;
            this.dialogContent.setHeaderText(title);
            this.dialogContent.setContentText(ex.getMessage());
            this.dialog.showDialog();
            return false;
        }
    }

    protected void reset(MouseEvent event) {
        MFXFilterPane filterPane = (MFXFilterPane)this.getSkinnable();
        if (!this.avoidQueryReset) {
            this.setQuery("");
        }
        filterPane.getActiveFilters().clear();
        filterPane.getOnReset().handle((Event)event);
    }

    public String getQuery() {
        return (String)this.query.get();
    }

    public void setQuery(String query) {
        this.query.set((Object)query);
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + this.filterBuilder.prefWidth(-1.0) + rightInset;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((MFXFilterPane)this.getSkinnable()).prefWidth(-1.0);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((MFXFilterPane)this.getSkinnable()).prefHeight(-1.0);
    }

    private /* synthetic */ void lambda$buildFilterBuilder$9(MFXComboBox predicatesCombo, ListProperty predicates, MFXComboBox filterCombo, MFXComboBox enumsCombo, MFXComboBox booleansCombo, MFXTextField searchField, ObservableValue observable, AbstractFilter oldValue, AbstractFilter newValue) {
        this.setQuery("");
        predicatesCombo.selectFirst();
        predicates.setAll(newValue.getPredicates());
        if (newValue instanceof EnumFilter) {
            this.avoidQueryReset = true;
            EnumFilter enumFilter = (EnumFilter)filterCombo.getValue();
            enumsCombo.setItems(FXCollections.observableArrayList((Object[])enumFilter.getEnumType().getEnumConstants()));
            enumsCombo.setVisible(true);
            booleansCombo.setVisible(false);
            searchField.setVisible(false);
        } else if (newValue instanceof BooleanFilter) {
            this.avoidQueryReset = true;
            booleansCombo.setVisible(true);
            enumsCombo.setVisible(false);
            searchField.setVisible(false);
        } else {
            this.avoidQueryReset = false;
            enumsCombo.setVisible(false);
            booleansCombo.setVisible(false);
            searchField.setVisible(true);
        }
    }
}

