/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.controls.BoundLabel;
import io.github.palexdev.materialfx.controls.cell.MFXTableRowCell;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.HBox;
import javafx.scene.shape.Rectangle;

public class MFXTableRowCellSkin<T, E>
extends SkinBase<MFXTableRowCell<T, E>> {
    private final HBox container;
    private final BoundLabel label;

    public MFXTableRowCellSkin(MFXTableRowCell<T, E> rowCell) {
        super(rowCell);
        this.label = new BoundLabel(rowCell);
        this.container = new HBox(rowCell.getGraphicTextGap(), new Node[]{this.label});
        this.container.alignmentProperty().bind((ObservableValue)rowCell.alignmentProperty());
        Node leading = rowCell.getLeadingGraphic();
        Node trailing = rowCell.getTrailingGraphic();
        if (leading != null) {
            this.container.getChildren().add(0, (Object)leading);
        }
        if (trailing != null) {
            this.container.getChildren().add((Object)trailing);
        }
        this.clip();
        this.getChildren().setAll((Object[])new Node[]{this.container});
        this.addListeners();
    }

    private void addListeners() {
        MFXTableRowCell rowCell = (MFXTableRowCell)this.getSkinnable();
        rowCell.leadingGraphicProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                this.container.getChildren().remove(oldValue);
            }
            if (newValue != null) {
                this.container.getChildren().add(0, newValue);
            }
        });
        rowCell.trailingGraphicProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                this.container.getChildren().remove(oldValue);
            }
            if (newValue != null) {
                this.container.getChildren().add(newValue);
            }
        });
    }

    protected void clip() {
        MFXTableRowCell rowCell = (MFXTableRowCell)this.getSkinnable();
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)rowCell.widthProperty());
        clip.heightProperty().bind((ObservableValue)rowCell.heightProperty());
        rowCell.setClip((Node)clip);
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        MFXTableRowCell rowCell = (MFXTableRowCell)this.getSkinnable();
        double leading = rowCell.getLeadingGraphic() != null ? rowCell.getLeadingGraphic().prefWidth(-1.0) : 0.0;
        double trailing = rowCell.getTrailingGraphic() != null ? rowCell.getTrailingGraphic().prefWidth(-1.0) : 0.0;
        return Math.max(super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset), leftInset + leading + this.label.prefWidth(-1.0) + trailing + rightInset);
    }
}

