/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins.base;

import io.github.palexdev.materialfx.controls.BoundLabel;
import io.github.palexdev.materialfx.controls.base.MFXLabeled;
import io.github.palexdev.materialfx.factories.InsetsFactory;
import io.github.palexdev.materialfx.utils.PositionUtils;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Labeled;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;

public abstract class MFXLabeledSkinBase<C extends Labeled>
extends SkinBase<C> {
    protected final BorderPane topContainer = new BorderPane();
    protected final BoundLabel text;

    protected MFXLabeledSkinBase(C labeled) {
        super(labeled);
        this.text = new BoundLabel((Labeled)labeled);
        if (((MFXLabeled)labeled).isTextExpand()) {
            this.text.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        }
    }

    protected abstract Pane getControlContainer();

    protected void addListeners() {
        Labeled labeled = (Labeled)this.getSkinnable();
        labeled.alignmentProperty().addListener(invalidated -> this.updateAlignment());
        ((MFXLabeled)labeled).contentDispositionProperty().addListener(invalidated -> this.initContainer());
        ((MFXLabeled)labeled).gapProperty().addListener(invalidated -> this.initContainer());
        ((MFXLabeled)labeled).textExpandProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.text.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            } else {
                this.text.setMaxSize(-1.0, -1.0);
            }
        });
    }

    protected void initContainer() {
        Labeled labeled = (Labeled)this.getSkinnable();
        Pane controlContainer = this.getControlContainer();
        ContentDisplay disposition = ((MFXLabeled)labeled).getContentDisposition();
        double gap = ((MFXLabeled)labeled).getGap();
        this.topContainer.getChildren().clear();
        this.topContainer.setCenter((Node)this.text);
        switch (disposition) {
            case TOP: {
                this.topContainer.setTop((Node)controlContainer);
                BorderPane.setMargin((Node)this.text, (Insets)InsetsFactory.top(gap));
                break;
            }
            case RIGHT: {
                this.topContainer.setRight((Node)controlContainer);
                BorderPane.setMargin((Node)this.text, (Insets)InsetsFactory.right(gap));
                break;
            }
            case BOTTOM: {
                this.topContainer.setBottom((Node)controlContainer);
                BorderPane.setMargin((Node)this.text, (Insets)InsetsFactory.bottom(gap));
                break;
            }
            case TEXT_ONLY: 
            case LEFT: {
                this.topContainer.setLeft((Node)controlContainer);
                BorderPane.setMargin((Node)this.text, (Insets)InsetsFactory.left(gap));
                break;
            }
            case GRAPHIC_ONLY: 
            case CENTER: {
                this.topContainer.setCenter((Node)controlContainer);
                BorderPane.setMargin((Node)this.text, (Insets)InsetsFactory.none());
            }
        }
    }

    protected void updateAlignment() {
        Labeled labeled = (Labeled)this.getSkinnable();
        Pane controlContainer = this.getControlContainer();
        Pos alignment = labeled.getAlignment();
        if (PositionUtils.isTop(alignment)) {
            BorderPane.setAlignment((Node)controlContainer, (Pos)Pos.TOP_CENTER);
        } else if (PositionUtils.isCenter(alignment)) {
            BorderPane.setAlignment((Node)controlContainer, (Pos)Pos.CENTER);
        } else if (PositionUtils.isBottom(alignment)) {
            BorderPane.setAlignment((Node)controlContainer, (Pos)Pos.BOTTOM_CENTER);
        }
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        Labeled labeled = (Labeled)this.getSkinnable();
        ContentDisplay contentDisposition = ((MFXLabeled)labeled).getContentDisposition();
        double minW = 0.0;
        switch (contentDisposition) {
            case RIGHT: 
            case TEXT_ONLY: 
            case LEFT: {
                minW = this.getControlContainer().prefWidth(-1.0) + ((MFXLabeled)labeled).getGap() + this.text.prefWidth(-1.0);
                break;
            }
            case TOP: 
            case BOTTOM: {
                minW = Math.max(this.getControlContainer().prefWidth(-1.0), this.text.prefWidth(-1.0));
                break;
            }
            case GRAPHIC_ONLY: 
            case CENTER: {
                minW = this.getControlContainer().prefWidth(-1.0);
            }
        }
        return leftInset + minW + rightInset;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((Labeled)this.getSkinnable()).prefWidth(-1.0);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((Labeled)this.getSkinnable()).prefHeight(-1.0);
    }
}

