/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.utils;

import io.github.palexdev.materialfx.utils.others.loader.MFXLoaderBean;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.util.Callback;

public class LoaderUtils {
    private static final ThreadPoolExecutor executor = new ThreadPoolExecutor(2, 4, 5L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), runnable -> {
        Thread thread = Executors.defaultThreadFactory().newThread(runnable);
        thread.setName("MFXLoaderThread");
        thread.setDaemon(true);
        return thread;
    });

    private LoaderUtils() {
    }

    public static Future<Parent> submit(Callable<Parent> task) {
        return executor.submit(task);
    }

    public static Parent fxmlLoad(MFXLoaderBean loaderBean) throws IOException {
        FXMLLoader fxmlLoader = new FXMLLoader();
        if (loaderBean.getControllerFactory() != null) {
            return LoaderUtils.fxmlLoad(fxmlLoader, loaderBean.getFxmlFile(), loaderBean.getControllerFactory());
        }
        return LoaderUtils.fxmlLoad(fxmlLoader, loaderBean.getFxmlFile());
    }

    public static Parent fxmlLoad(FXMLLoader fxmlLoader, MFXLoaderBean loaderBean) throws IOException {
        if (loaderBean.getControllerFactory() != null) {
            return LoaderUtils.fxmlLoad(fxmlLoader, loaderBean.getFxmlFile(), loaderBean.getControllerFactory());
        }
        return LoaderUtils.fxmlLoad(fxmlLoader, loaderBean.getFxmlFile());
    }

    private static Parent fxmlLoad(FXMLLoader fxmlLoader, URL fxmlURL) throws IOException {
        fxmlLoader.setLocation(fxmlURL);
        return (Parent)fxmlLoader.load();
    }

    private static Parent fxmlLoad(FXMLLoader fxmlLoader, URL fxmlURL, Callback<Class<?>, Object> controllerFactory) throws IOException {
        fxmlLoader.setLocation(fxmlURL);
        fxmlLoader.setControllerFactory(controllerFactory);
        return (Parent)fxmlLoader.load();
    }

    public static void checkFxmlFile(URL fxmlFile) {
        if (!fxmlFile.toString().endsWith(".fxml")) {
            throw new IllegalArgumentException("The URL is invalid, doesn't end with '.fxml'!");
        }
    }

    public static String generateKey(URL fxmlFile) {
        String url = fxmlFile.toString();
        int lastSlash = url.lastIndexOf("/");
        int lastDot = url.lastIndexOf(".");
        return url.substring(lastSlash + 1, lastDot);
    }

    static {
        executor.allowCoreThreadTimeOut(true);
    }
}

