/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.bindings;

import io.github.palexdev.materialfx.bindings.BiBindingManager;
import io.github.palexdev.materialfx.bindings.BindingBuilder;
import io.github.palexdev.materialfx.bindings.BindingHelper;
import java.util.WeakHashMap;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyFloatWrapper;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyLongWrapper;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;

public class BindingManager {
    private static final BindingManager instance = new BindingManager();
    private final WeakHashMap<ObservableValue, BindingHelper> bindings = new WeakHashMap();

    public static BindingManager instance() {
        return instance;
    }

    private BindingManager() {
    }

    public <T> BindingBuilder<T> bind(ObservableValue<? extends T> target) {
        return new BindingBuilder<T>(target);
    }

    public <T> BindingBuilder<T> bind(Property<T> target) {
        return new BindingBuilder<Object>((ObservableValue<Object>)target).with((oldValue, newValue) -> target.setValue(newValue));
    }

    public <T> BindingManager apply(BindingBuilder<T> bindingBuilder, BindingHelper<T> bindingHelper) {
        ObservableValue<T> target = bindingBuilder.target();
        this.biBindingCheck(target);
        if (this.bindings.containsKey(target)) {
            this.unbind(target);
        }
        this.bindings.put(target, bindingHelper);
        ((BindingHelper)bindingHelper.bind((ObservableValue)target)).to(bindingBuilder.source());
        return this;
    }

    public <T> BindingManager unbind(ObservableValue<T> target) {
        BindingHelper bindingHelper = this.bindings.remove(target);
        if (bindingHelper != null) {
            bindingHelper.unbind();
        }
        return this;
    }

    public BindingManager unbindReadOnly(ReadOnlyBooleanWrapper target) {
        return this.unbind((ObservableValue)target.getReadOnlyProperty());
    }

    public BindingManager unbindReadOnly(ReadOnlyStringWrapper target) {
        return this.unbind((ObservableValue)target.getReadOnlyProperty());
    }

    public BindingManager unbindReadOnly(ReadOnlyIntegerWrapper target) {
        return this.unbind((ObservableValue)target.getReadOnlyProperty());
    }

    public BindingManager unbindReadOnly(ReadOnlyLongWrapper target) {
        return this.unbind((ObservableValue)target.getReadOnlyProperty());
    }

    public BindingManager unbindReadOnly(ReadOnlyFloatWrapper target) {
        return this.unbind((ObservableValue)target.getReadOnlyProperty());
    }

    public BindingManager unbindReadOnly(ReadOnlyDoubleWrapper target) {
        return this.unbind((ObservableValue)target.getReadOnlyProperty());
    }

    public <T> BindingManager unbindReadOnly(ReadOnlyObjectWrapper<T> target) {
        return this.unbind((ObservableValue<T>)target.getReadOnlyProperty());
    }

    public void dispose() {
        this.bindings.values().forEach(BindingHelper::unbind);
        this.bindings.clear();
    }

    public int size() {
        return this.bindings.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isIgnoreBinding(ObservableValue target) {
        BindingHelper bindingHelper = this.bindings.get(target);
        return bindingHelper != null && bindingHelper.isIgnoreBinding();
    }

    public boolean isBound(ObservableValue target) {
        return this.bindings.containsKey(target);
    }

    private <T> void biBindingCheck(ObservableValue<? extends T> target) {
        if (BiBindingManager.instance().isBound(target)) {
            BiBindingManager.instance().disposeFor(target);
        }
    }
}

