/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls.legacy;

import io.github.palexdev.materialfx.MFXResourcesLoader;
import io.github.palexdev.materialfx.beans.MFXSnapshotWrapper;
import io.github.palexdev.materialfx.controls.legacy.MFXLegacyListCell;
import io.github.palexdev.materialfx.skins.legacy.MFXLegacyComboBoxSkin;
import io.github.palexdev.materialfx.validation.MFXValidator;
import io.github.palexdev.materialfx.validation.Validated;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Labeled;
import javafx.scene.control.ListCell;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeLineCap;

public class MFXLegacyComboBox<T>
extends ComboBox<T>
implements Validated {
    private static final StyleablePropertyFactory<MFXLegacyComboBox<?>> FACTORY = new StyleablePropertyFactory(ComboBox.getClassCssMetaData());
    private final String STYLE_CLASS = "mfx-legacy-combo-box";
    private final String STYLESHEET = MFXResourcesLoader.load("css/legacy/MFXComboBox.css");
    private final MFXValidator validator = new MFXValidator();
    private final ObjectProperty<Paint> invalidLineColor = new SimpleObjectProperty((Object)Color.web((String)"#EF6E6B"));
    protected static final PseudoClass INVALID_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"invalid");
    private final StyleableObjectProperty<Paint> lineColor = new SimpleStyleableObjectProperty(StyleableProperties.LINE_COLOR, (Object)this, "lineColor", (Object)Color.rgb((int)50, (int)120, (int)220));
    private final StyleableObjectProperty<Paint> unfocusedLineColor = new SimpleStyleableObjectProperty(StyleableProperties.UNFOCUSED_LINE_COLOR, (Object)this, "unfocusedLineColor", (Object)Color.rgb((int)77, (int)77, (int)77));
    private final StyleableDoubleProperty lineStrokeWidth = new SimpleStyleableDoubleProperty(StyleableProperties.LINE_STROKE_WIDTH, (Object)this, "lineStrokeWidth", Double.valueOf(2.0));
    private final StyleableObjectProperty<StrokeLineCap> lineStrokeCap = new SimpleStyleableObjectProperty(StyleableProperties.LINE_STROKE_CAP, (Object)this, "lineStrokeCap", (Object)StrokeLineCap.ROUND);
    private final StyleableBooleanProperty animateLines = new SimpleStyleableBooleanProperty(StyleableProperties.ANIMATE_LINES, (Object)this, "animateLines", true);
    private final StyleableBooleanProperty isValidated = new SimpleStyleableBooleanProperty(StyleableProperties.IS_VALIDATED, (Object)this, "isValidated", false);

    public MFXLegacyComboBox() {
        this.initialize();
    }

    public MFXLegacyComboBox(ObservableList<T> observableList) {
        super(observableList);
        this.initialize();
    }

    @Override
    public MFXValidator getValidator() {
        return this.validator;
    }

    public Paint getInvalidLineColor() {
        return (Paint)this.invalidLineColor.get();
    }

    public ObjectProperty<Paint> invalidLineColorProperty() {
        return this.invalidLineColor;
    }

    public void setInvalidLineColor(Paint invalidLineColor) {
        this.invalidLineColor.set((Object)invalidLineColor);
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-legacy-combo-box");
        this.setCellFactory(listCell -> new MFXLegacyListCell<T>(){

            @Override
            protected void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                this.getChildren().remove((Object)this.lookup(".mfx-ripple-generator"));
            }
        });
        this.setButtonCell(new ListCell<T>(){
            {
                MFXLegacyComboBox.this.valueProperty().addListener(observable -> {
                    if (MFXLegacyComboBox.this.getValue() == null) {
                        this.updateItem(null, true);
                    }
                });
            }

            protected void updateItem(T item, boolean empty) {
                MFXLegacyComboBox.this.updateComboItem(this, item, empty);
            }
        });
    }

    protected void updateComboItem(ListCell<T> cell, T item, boolean empty) {
        if (empty || item == null) {
            cell.setGraphic(null);
            cell.setText(this.getPromptText());
            return;
        }
        if (item instanceof Labeled) {
            Labeled nodeItem = (Labeled)item;
            if (nodeItem.getGraphic() != null) {
                cell.setGraphic(new MFXSnapshotWrapper(nodeItem.getGraphic()).getGraphic());
            }
            cell.setText(nodeItem.getText());
        } else {
            cell.setText(item.toString());
        }
    }

    public Paint getLineColor() {
        return (Paint)this.lineColor.get();
    }

    public StyleableObjectProperty<Paint> lineColorProperty() {
        return this.lineColor;
    }

    public void setLineColor(Paint lineColor) {
        this.lineColor.set((Object)lineColor);
    }

    public Paint getUnfocusedLineColor() {
        return (Paint)this.unfocusedLineColor.get();
    }

    public StyleableObjectProperty<Paint> unfocusedLineColorProperty() {
        return this.unfocusedLineColor;
    }

    public void setUnfocusedLineColor(Paint unfocusedLineColor) {
        this.unfocusedLineColor.set((Object)unfocusedLineColor);
    }

    public double getLineStrokeWidth() {
        return this.lineStrokeWidth.get();
    }

    public StyleableDoubleProperty lineStrokeWidthProperty() {
        return this.lineStrokeWidth;
    }

    public void setLineStrokeWidth(double lineStrokeWidth) {
        this.lineStrokeWidth.set(lineStrokeWidth);
    }

    public StrokeLineCap getLineStrokeCap() {
        return (StrokeLineCap)this.lineStrokeCap.get();
    }

    public StyleableObjectProperty<StrokeLineCap> lineStrokeCapProperty() {
        return this.lineStrokeCap;
    }

    public void setLineStrokeCap(StrokeLineCap lineStrokeCap) {
        this.lineStrokeCap.set((Object)lineStrokeCap);
    }

    public boolean isAnimateLines() {
        return this.animateLines.get();
    }

    public StyleableBooleanProperty animateLinesProperty() {
        return this.animateLines;
    }

    public void setAnimateLines(boolean animateLines) {
        this.animateLines.set(animateLines);
    }

    public boolean isValidated() {
        return this.isValidated.get();
    }

    public StyleableBooleanProperty isValidatedProperty() {
        return this.isValidated;
    }

    public void setValidated(boolean isValidated) {
        this.isValidated.set(isValidated);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getControlCssMetaDataList() {
        return StyleableProperties.cssMetaDataList;
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXLegacyComboBoxSkin(this);
    }

    public String getUserAgentStylesheet() {
        return this.STYLESHEET;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return MFXLegacyComboBox.getControlCssMetaDataList();
    }

    private static class StyleableProperties {
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<MFXLegacyComboBox<?>, Paint> LINE_COLOR;
        private static final CssMetaData<MFXLegacyComboBox<?>, Paint> UNFOCUSED_LINE_COLOR;
        private static final CssMetaData<MFXLegacyComboBox<?>, Number> LINE_STROKE_WIDTH;
        private static final CssMetaData<MFXLegacyComboBox<?>, StrokeLineCap> LINE_STROKE_CAP;
        private static final CssMetaData<MFXLegacyComboBox<?>, Boolean> ANIMATE_LINES;
        private static final CssMetaData<MFXLegacyComboBox<?>, Boolean> IS_VALIDATED;

        private StyleableProperties() {
        }

        static {
            LINE_COLOR = FACTORY.createPaintCssMetaData("-mfx-line-color", MFXLegacyComboBox::lineColorProperty, (Paint)Color.rgb((int)50, (int)120, (int)220));
            UNFOCUSED_LINE_COLOR = FACTORY.createPaintCssMetaData("-mfx-unfocused-line-color", MFXLegacyComboBox::unfocusedLineColorProperty, (Paint)Color.rgb((int)77, (int)77, (int)77));
            LINE_STROKE_WIDTH = FACTORY.createSizeCssMetaData("-mfx-line-stroke-width", MFXLegacyComboBox::lineStrokeWidthProperty, (Number)2.0);
            LINE_STROKE_CAP = FACTORY.createEnumCssMetaData(StrokeLineCap.class, "-mfx-line-stroke-cap", MFXLegacyComboBox::lineStrokeCapProperty, (Enum)StrokeLineCap.ROUND);
            ANIMATE_LINES = FACTORY.createBooleanCssMetaData("-mfx-animate-lines", MFXLegacyComboBox::animateLinesProperty, true);
            IS_VALIDATED = FACTORY.createBooleanCssMetaData("-mfx-validate", MFXLegacyComboBox::isValidatedProperty, false);
            ArrayList lcbCssMetaData = new ArrayList(ComboBox.getClassCssMetaData());
            Collections.addAll(lcbCssMetaData, ANIMATE_LINES, LINE_COLOR, UNFOCUSED_LINE_COLOR, LINE_STROKE_WIDTH, LINE_STROKE_CAP, IS_VALIDATED);
            cssMetaDataList = Collections.unmodifiableList(lcbCssMetaData);
        }
    }
}

