/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.controls.BoundLabel;
import io.github.palexdev.materialfx.controls.MFXContextMenu;
import io.github.palexdev.materialfx.controls.MFXContextMenuItem;
import io.github.palexdev.materialfx.controls.MFXIconWrapper;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.Window;

public class MFXContextMenuItemSkin
extends SkinBase<MFXContextMenuItem> {
    private final HBox container;
    private final MFXIconWrapper icon;
    private final BoundLabel label;
    private final Label accelerator;

    public MFXContextMenuItemSkin(MFXContextMenuItem item) {
        super((Control)item);
        Tooltip tooltip;
        this.label = new BoundLabel(item);
        this.label.graphicProperty().unbind();
        this.label.setGraphic(null);
        this.icon = new MFXIconWrapper(null, 24.0);
        this.icon.setIcon(item.getGraphic());
        this.icon.iconProperty().bind((ObservableValue)item.graphicProperty());
        this.accelerator = new Label();
        this.accelerator.getStyleClass().add((Object)"accelerator");
        this.accelerator.textProperty().bind((ObservableValue)item.acceleratorProperty());
        this.accelerator.setAlignment(Pos.CENTER_RIGHT);
        this.accelerator.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)this.accelerator, (Priority)Priority.ALWAYS);
        this.container = new HBox(10.0, new Node[]{this.icon, this.label, this.accelerator});
        this.container.setAlignment(Pos.CENTER_LEFT);
        if (item.getTooltipSupplier() != null && (tooltip = item.getTooltipSupplier().get()) != null) {
            item.setTooltip(tooltip);
        }
        this.addListeners();
        this.getChildren().setAll((Object[])new Node[]{this.container});
    }

    private void addListeners() {
        MFXContextMenuItem item = (MFXContextMenuItem)this.getSkinnable();
        item.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
            Scene scene = item.getScene();
            Window window = scene.getWindow();
            if (window instanceof MFXContextMenu) {
                window.hide();
            }
        });
        item.tooltipSupplierProperty().addListener((observable, oldValue, newValue) -> {
            Tooltip tooltip;
            item.setTooltip(null);
            if (newValue != null && (tooltip = item.getTooltipSupplier().get()) != null) {
                item.setTooltip(tooltip);
            }
        });
        item.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> {
            if (event.getButton() != MouseButton.PRIMARY) {
                return;
            }
            item.fireEvent((Event)new ActionEvent());
        });
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + this.icon.getSize() + Math.abs(this.label.snappedLeftInset()) + this.label.prefWidth(-1.0) + Math.abs(this.label.snappedRightInset()) + this.accelerator.snappedLeftInset() + this.accelerator.prefWidth(-1.0) + this.accelerator.snappedRightInset() + rightInset;
    }
}

