/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.beans.PositionBean;
import io.github.palexdev.materialfx.controls.BoundTextField;
import io.github.palexdev.materialfx.controls.MFXTextField;
import io.github.palexdev.materialfx.effects.Interpolators;
import io.github.palexdev.materialfx.enums.FloatMode;
import io.github.palexdev.materialfx.utils.AnimationUtils;
import io.github.palexdev.materialfx.utils.ColorUtils;
import io.github.palexdev.materialfx.utils.PositionUtils;
import javafx.animation.Animation;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;

public class MFXTextFieldSkin
extends SkinBase<MFXTextField> {
    private final BoundTextField boundField;
    private final Label floatingText;
    private static final PseudoClass FOCUS_WITHIN_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"focus-within");
    private final ObjectProperty<PositionBean> floatingPos = new SimpleObjectProperty((Object)PositionBean.of(0.0, 0.0));
    private final BooleanExpression floating;
    private final double scaleValue = 0.85;
    private final Scale scale = Transform.scale((double)0.85, (double)0.85, (double)0.0, (double)0.0);
    private final Translate translate = Transform.translate((double)0.0, (double)0.0);
    private Animation floatAnimation;
    private boolean skipLayout = false;

    public MFXTextFieldSkin(MFXTextField textField, BoundTextField boundField) {
        super((Control)textField);
        this.boundField = boundField;
        boundField.setManaged(false);
        this.floatingText = new Label();
        this.floatingText.getStyleClass().setAll((Object[])new String[]{"floating-text"});
        this.floatingText.textProperty().bind((ObservableValue)textField.floatingTextProperty());
        this.floatingText.getTransforms().addAll((Object[])new Transform[]{this.scale, this.translate});
        if (textField.getFloatMode() == FloatMode.DISABLED) {
            this.floatingText.setVisible(false);
        }
        this.floating = Bindings.createBooleanBinding(() -> this.getFloatY() != 0.0, (Observable[])new Observable[]{this.floatingPos});
        textField.floatingProperty().bind((ObservableValue)this.floating);
        this.getChildren().setAll((Object[])new Node[]{this.floatingText, boundField});
        if (!this.shouldFloat()) {
            this.scale.setX(1.0);
            this.scale.setY(1.0);
        }
        if (textField.getLeadingIcon() != null) {
            this.getChildren().add((Object)textField.getLeadingIcon());
        }
        if (textField.getTrailingIcon() != null) {
            this.getChildren().add((Object)textField.getTrailingIcon());
        }
        this.addListeners();
    }

    private void addListeners() {
        MFXTextField textField = (MFXTextField)this.getSkinnable();
        textField.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
            this.boundField.requestFocus();
            this.boundField.deselect();
        });
        this.floatingPos.addListener((observable, oldValue, newValue) -> this.handleFloatingText());
        this.boundField.layoutBoundsProperty().addListener(invalidated -> {
            this.skipLayout = true;
            textField.requestLayout();
        });
        this.floatingText.layoutBoundsProperty().addListener(invalidated -> {
            this.skipLayout = true;
        });
        textField.scaleOnAboveProperty().addListener((observable, oldValue, newValue) -> textField.requestLayout());
        textField.promptTextProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.isEmpty() && !this.isFloating()) {
                textField.requestLayout();
            }
        });
        textField.textProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.isEmpty() && !this.isFloating()) {
                textField.requestLayout();
            }
        });
        textField.floatModeProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == FloatMode.DISABLED) {
                this.floatingText.setVisible(false);
            }
            textField.requestLayout();
        });
        textField.floatingTextGapProperty().addListener((observable, oldValue, newValue) -> textField.requestLayout());
        textField.borderGapProperty().addListener((observable, oldValue, newValue) -> textField.requestLayout());
        textField.focusedProperty().addListener((observable, oldValue, newValue) -> this.boundField.requestFocus());
        this.boundField.focusedProperty().addListener((observable, oldValue, newValue) -> {
            textField.requestLayout();
            this.pseudoClassStateChanged(FOCUS_WITHIN_PSEUDO_CLASS, (boolean)newValue);
        });
        textField.leadingIconProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                this.getChildren().remove(oldValue);
            }
            if (newValue != null) {
                this.getChildren().add(newValue);
            }
        });
        textField.trailingIconProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                this.getChildren().remove(oldValue);
            }
            if (newValue != null) {
                this.getChildren().add(newValue);
            }
        });
        this.boundField.selectedTextProperty().addListener((observable, oldValue, newValue) -> {
            if (!textField.isSelectable() && !newValue.isEmpty()) {
                this.boundField.deselect();
            }
        });
        this.boundField.textProperty().addListener((observable, oldValue, newValue) -> {
            int limit = textField.getTextLimit();
            if (limit == -1) {
                return;
            }
            if (newValue.length() > limit) {
                this.boundField.setText((String)oldValue);
            }
        });
        textField.textFillProperty().addListener((observable, oldValue, newValue) -> this.updateTextColor((Color)newValue));
    }

    private void handleFloatingText() {
        double targetScale;
        MFXTextField textField = (MFXTextField)this.getSkinnable();
        double targetX = this.getFloatX();
        double targetY = this.getFloatY();
        double d = targetScale = this.shouldFloat() ? 0.85 : 1.0;
        if (textField.getFloatMode() == FloatMode.ABOVE && !textField.scaleOnAbove()) {
            targetScale = 1.0;
        }
        if (textField.isAnimated()) {
            if (this.floatAnimation != null && AnimationUtils.isPlaying(this.floatAnimation)) {
                this.floatAnimation.stop();
            }
            this.floatAnimation = AnimationUtils.TimelineBuilder.build().add(AnimationUtils.KeyFrames.of(150.0, this.scale.xProperty(), Double.valueOf(targetScale), Interpolators.INTERPOLATOR_V1), AnimationUtils.KeyFrames.of(150.0, this.scale.yProperty(), Double.valueOf(targetScale), Interpolators.INTERPOLATOR_V1), AnimationUtils.KeyFrames.of(150.0, this.translate.xProperty(), Double.valueOf(targetX), Interpolators.INTERPOLATOR_V1), AnimationUtils.KeyFrames.of(150.0, this.translate.yProperty(), Double.valueOf(targetY), Interpolators.INTERPOLATOR_V1)).getAnimation();
            this.floatAnimation.play();
        } else {
            this.scale.setX(targetScale);
            this.scale.setY(targetScale);
            this.translate.setX(targetX);
            this.translate.setY(targetY);
        }
    }

    private boolean shouldFloat() {
        MFXTextField textField = (MFXTextField)this.getSkinnable();
        boolean modeCondition = textField.getFloatMode() == FloatMode.ABOVE;
        boolean floatTextCondition = textField.getFloatingText() != null && !textField.getFloatingText().isEmpty();
        boolean textCondition = textField.getText() != null && !textField.getText().isEmpty();
        boolean promptTextCondition = textField.getPromptText() != null && !textField.getPromptText().isEmpty();
        return floatTextCondition && textCondition || promptTextCondition || modeCondition || this.boundField.isFocused();
    }

    protected void updateTextColor(Color color) {
        String colorString = ColorUtils.rgba(color);
        this.boundField.setStyle("-fx-text-inner-color: " + colorString + ";\n-fx-highlight-text-fill: " + colorString + ";\n");
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        MFXTextField textField = (MFXTextField)this.getSkinnable();
        Node leading = textField.getLeadingIcon();
        Node trailing = textField.getTrailingIcon();
        double gap = textField.getGraphicTextGap();
        return leftInset + (leading != null ? leading.prefWidth(-1.0) + gap : 0.0) + Math.max(this.boundField.prefWidth(-1.0), this.floatingText.prefWidth(-1.0)) + (trailing != null ? trailing.prefWidth(-1.0) + gap : 0.0) + rightInset;
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        MFXTextField textField = (MFXTextField)this.getSkinnable();
        FloatMode floatMode = textField.getFloatMode();
        Node leading = textField.getLeadingIcon();
        Node trailing = textField.getTrailingIcon();
        double iconsMax = topInset + Math.max(leading != null ? leading.prefHeight(-1.0) : 0.0, trailing != null ? trailing.prefHeight(-1.0) : 0.0) + bottomInset;
        double height = 0.0;
        switch (floatMode) {
            case DISABLED: 
            case ABOVE: {
                height = topInset + this.boundField.prefHeight(-1.0) + bottomInset;
                break;
            }
            case BORDER: {
                height = topInset + this.floatingText.prefHeight(-1.0) / 2.0 + this.boundField.prefHeight(-1.0) + bottomInset;
                break;
            }
            case INLINE: {
                double gap = textField.getFloatingTextGap();
                height = topInset + this.floatingText.prefHeight(-1.0) * 0.85 + gap + this.boundField.prefHeight(-1.0) + bottomInset;
                break;
            }
        }
        return Math.max(iconsMax, height);
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (((MFXTextField)this.getSkinnable()).getMaxWidth() == Double.MAX_VALUE) {
            return Double.MAX_VALUE;
        }
        return ((MFXTextField)this.getSkinnable()).prefWidth(-1.0);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (((MFXTextField)this.getSkinnable()).getMaxHeight() == Double.MAX_VALUE) {
            return Double.MAX_VALUE;
        }
        return ((MFXTextField)this.getSkinnable()).prefHeight(-1.0);
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        MFXTextField textField = (MFXTextField)this.getSkinnable();
        Node leading = textField.getLeadingIcon();
        Node trailing = textField.getTrailingIcon();
        double graphicTextGap = textField.getGraphicTextGap();
        FloatMode floatMode = textField.getFloatMode();
        VPos textVAlignment = floatMode != FloatMode.INLINE ? VPos.CENTER : VPos.BOTTOM;
        double scaleValue = floatMode == FloatMode.ABOVE && !textField.scaleOnAbove() ? 1.0 : this.scaleValue;
        double xOffset = x;
        if (leading != null) {
            PositionBean leadingPos = PositionUtils.computePosition((Region)textField, leading, x, y, w, h, 0.0, Insets.EMPTY, HPos.LEFT, VPos.CENTER);
            double leadingW = leading.prefWidth(-1.0);
            double leadingH = leading.prefHeight(-1.0);
            leading.resizeRelocate(leadingPos.getX(), leadingPos.getY(), leadingW, leadingH);
            xOffset += leadingW + graphicTextGap;
        }
        if (trailing != null) {
            PositionBean trailingPos = PositionUtils.computePosition((Region)textField, trailing, x, y, w, h, 0.0, Insets.EMPTY, HPos.RIGHT, VPos.CENTER);
            double trailingW = trailing.prefWidth(-1.0);
            double trailingH = trailing.prefHeight(-1.0);
            trailing.resizeRelocate(trailingPos.getX(), trailingPos.getY(), trailingW, trailingH);
        }
        double floatW = this.floatingText.prefWidth(-1.0);
        double floatH = this.floatingText.prefHeight(-1.0);
        double floatX = floatMode == FloatMode.ABOVE ? 1.0 : xOffset;
        PositionBean floatPos = PositionUtils.computePosition((Region)textField, (Node)this.floatingText, floatX, y, w, h, 0.0, Insets.EMPTY, HPos.LEFT, VPos.CENTER);
        this.floatingText.resizeRelocate(floatPos.getX(), floatPos.getY(), floatW, floatH);
        double textW = w - (leading != null ? leading.prefWidth(-1.0) + graphicTextGap : 0.0) - (trailing != null ? trailing.prefWidth(-1.0) + graphicTextGap : 0.0);
        double textH = this.boundField.prefHeight(-1.0);
        PositionBean textPos = PositionUtils.computePosition((Region)textField, (Node)this.boundField, xOffset, y, w, h, 0.0, Insets.EMPTY, HPos.LEFT, textVAlignment);
        this.boundField.resizeRelocate(textPos.getX(), textPos.getY(), textW, textH);
        if (this.skipLayout) {
            this.skipLayout = false;
            return;
        }
        double targetX = 0.0;
        double targetY = 0.0;
        if (this.shouldFloat()) {
            if (floatMode == FloatMode.BORDER) {
                floatX = 0.0;
            }
            PositionBean floatTopPos = PositionUtils.computePosition((Region)textField, (Node)this.floatingText, floatX, y, w, h, 0.0, Insets.EMPTY, HPos.LEFT, VPos.TOP);
            targetY = floatTopPos.getY() - floatPos.getY() / scaleValue + 1.0;
            targetX = floatTopPos.getX() - floatPos.getX() / scaleValue + 1.0;
            switch (floatMode) {
                case ABOVE: {
                    targetX += textField.getBorderGap();
                    targetY -= this.snappedTopInset() + textField.getFloatingTextGap() + floatH / scaleValue;
                    break;
                }
                case BORDER: {
                    targetX += textField.getBorderGap();
                    targetY -= this.snappedTopInset() + floatH / 2.0 / scaleValue;
                }
            }
        } else if (floatMode == FloatMode.BORDER) {
            targetX = leading != null ? leading.prefWidth(-1.0) + graphicTextGap : 0.0;
        }
        this.setFloatPos(PositionBean.of(targetX, targetY));
    }

    private double getFloatX() {
        return ((PositionBean)this.floatingPos.get()).getX();
    }

    private double getFloatY() {
        return ((PositionBean)this.floatingPos.get()).getY();
    }

    private void setFloatPos(PositionBean pos) {
        this.floatingPos.set((Object)pos);
    }

    private boolean isFloating() {
        return this.floating.get();
    }
}

