/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.utils.others;

import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ReusableScheduledExecutor {
    private final ScheduledExecutorService service;
    private ScheduledFuture<?> task;

    public ReusableScheduledExecutor(ScheduledExecutorService service) {
        this.service = service;
    }

    public void cancel() {
        this.task.cancel(false);
    }

    public void cancelNow() {
        this.task.cancel(true);
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        this.task = this.service.schedule(command, delay, unit);
        return this.task;
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        this.task = this.service.schedule(callable, delay, unit);
        return this.task;
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        this.task = this.service.scheduleAtFixedRate(command, initialDelay, period, unit);
        return this.task;
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        this.task = this.service.scheduleWithFixedDelay(command, initialDelay, delay, unit);
        return this.task;
    }

    public ScheduledExecutorService getService() {
        return this.service;
    }
}

