/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.beans.properties.base;

import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.value.ObservableValue;

public interface SynchronizedProperty<T>
extends Property<T> {
    public void setAndWait(T var1, ObservableValue<?> var2);

    public boolean isWaiting();

    public ReadOnlyBooleanProperty waiting();

    public void awake();

    public static class Helper {
        public static <T> boolean check(SynchronizedProperty<T> property, T value, ObservableValue<?> observable) {
            SynchronizedProperty synchronizedProperty;
            if (observable == property) {
                throw new IllegalArgumentException("The passed property cannot be the same as this! Proceeding with this method would lead to a deadlock.");
            }
            if (property.isBound()) {
                throw new IllegalStateException("A bound value cannot be set!");
            }
            if (property.isWaiting()) {
                throw new IllegalStateException("The property is already waiting for some other observable!");
            }
            if (observable instanceof SynchronizedProperty && (synchronizedProperty = (SynchronizedProperty)observable).isWaiting()) {
                throw new IllegalArgumentException("The passed property is already waiting for some other property! Proceeding with this method would lead to a deadlock.");
            }
            return property.getValue() == null || !property.getValue().equals(value);
        }
    }
}

