/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.beans.properties.resettable;

import io.github.palexdev.materialfx.beans.properties.base.ResettableProperty;
import javafx.beans.property.SimpleObjectProperty;

public class ResettableObjectProperty<T>
extends SimpleObjectProperty<T>
implements ResettableProperty<T> {
    private T defaultValue;
    private boolean fireChangeOnReset = false;
    private boolean hasBeenReset = false;

    public ResettableObjectProperty() {
    }

    public ResettableObjectProperty(T initialValue) {
        super(initialValue);
    }

    public ResettableObjectProperty(T initialValue, T defaultValue) {
        super(initialValue);
        this.defaultValue = defaultValue;
    }

    public ResettableObjectProperty(Object bean, String name) {
        super(bean, name);
    }

    public ResettableObjectProperty(Object bean, String name, T initialValue) {
        super(bean, name, initialValue);
    }

    public ResettableObjectProperty(Object bean, String name, T initialValue, T defaultValue) {
        super(bean, name, initialValue);
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean isFireChangeOnReset() {
        return this.fireChangeOnReset;
    }

    @Override
    public void setFireChangeOnReset(boolean fireChangeOnReset) {
        this.fireChangeOnReset = fireChangeOnReset;
    }

    public void set(T newValue) {
        this.hasBeenReset = newValue == this.defaultValue;
        super.set(newValue);
    }

    protected void fireValueChangedEvent() {
        if (this.getValue().equals(this.defaultValue) && !this.fireChangeOnReset) {
            return;
        }
        super.fireValueChangedEvent();
    }

    @Override
    public boolean hasBeenReset() {
        return this.hasBeenReset;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
    }
}

