/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.beans.properties.resettable;

import io.github.palexdev.materialfx.beans.properties.base.ResettableProperty;
import javafx.beans.property.SimpleStringProperty;

public class ResettableStringProperty
extends SimpleStringProperty
implements ResettableProperty<String> {
    private String defaultValue;
    private boolean fireChangeOnReset = false;
    private boolean hasBeenReset = false;

    public ResettableStringProperty() {
    }

    public ResettableStringProperty(String initialValue) {
        super(initialValue);
    }

    public ResettableStringProperty(String initialValue, String defaultValue) {
        super(initialValue);
        this.defaultValue = defaultValue;
    }

    public ResettableStringProperty(Object bean, String name) {
        super(bean, name);
    }

    public ResettableStringProperty(Object bean, String name, String initialValue) {
        super(bean, name, initialValue);
    }

    public ResettableStringProperty(Object bean, String name, String initialValue, String defaultValue) {
        super(bean, name, initialValue);
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean isFireChangeOnReset() {
        return this.fireChangeOnReset;
    }

    @Override
    public void setFireChangeOnReset(boolean fireChangeOnReset) {
        this.fireChangeOnReset = fireChangeOnReset;
    }

    public void set(String newValue) {
        this.hasBeenReset = newValue.equals(this.defaultValue);
        super.set(newValue);
    }

    protected void fireValueChangedEvent() {
        if (this.getValue().equals(this.defaultValue) && !this.fireChangeOnReset) {
            return;
        }
        super.fireValueChangedEvent();
    }

    @Override
    public boolean hasBeenReset() {
        return this.hasBeenReset;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }
}

