/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.bindings;

import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public class BooleanListBinding
extends BooleanBinding {
    private final ObservableList<BooleanProperty> boundList;
    private final ListChangeListener<BooleanProperty> changeListener;
    private BooleanProperty[] observedProperties;

    public BooleanListBinding(ObservableList<BooleanProperty> boundList) {
        this.boundList = boundList;
        this.changeListener = c -> this.refreshBinding();
        this.boundList.addListener(this.changeListener);
        this.refreshBinding();
    }

    protected boolean computeValue() {
        for (BooleanProperty bp : this.observedProperties) {
            if (bp.get()) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        this.boundList.removeListener(this.changeListener);
        super.dispose();
    }

    private void refreshBinding() {
        super.unbind((Observable[])this.observedProperties);
        this.observedProperties = (BooleanProperty[])this.boundList.toArray((Object[])new BooleanProperty[0]);
        super.bind((Observable[])this.observedProperties);
        this.invalidate();
    }
}

