/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.builders.layout;

import io.github.palexdev.materialfx.builders.base.INodeBuilder;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.NodeOrientation;
import javafx.scene.CacheHint;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.effect.Effect;

public class NodeBuilder<N extends Node>
implements INodeBuilder<N> {
    protected final N node;

    public NodeBuilder(N node) {
        this.node = node;
    }

    public static NodeBuilder<Node> node(Node node) {
        return new NodeBuilder<Node>(node);
    }

    public NodeBuilder<N> setId(String id) {
        this.node.setId(id);
        return this;
    }

    public NodeBuilder<N> setStyle(String style) {
        this.node.setStyle(style);
        return this;
    }

    public NodeBuilder<N> addStyleClasses(String ... styleClasses) {
        this.node.getStyleClass().addAll((Object[])styleClasses);
        return this;
    }

    public NodeBuilder<N> setStyleClasses(String ... styleClasses) {
        this.node.getStyleClass().setAll((Object[])styleClasses);
        return this;
    }

    public NodeBuilder<N> pseudoClassStateChanged(PseudoClass pseudoClass, boolean active) {
        this.node.pseudoClassStateChanged(pseudoClass, active);
        return this;
    }

    public NodeBuilder<N> setVisible(boolean visible) {
        this.node.setVisible(visible);
        return this;
    }

    public NodeBuilder<N> setCursor(Cursor cursor) {
        this.node.setCursor(cursor);
        return this;
    }

    public NodeBuilder<N> setOpacity(double opacity) {
        this.node.setOpacity(opacity);
        return this;
    }

    public NodeBuilder<N> setClip(Node clip) {
        this.node.setClip(clip);
        return this;
    }

    public NodeBuilder<N> setCache(boolean cache) {
        this.node.setCache(cache);
        return this;
    }

    public NodeBuilder<N> setCacheHint(CacheHint cacheHint) {
        this.node.setCacheHint(cacheHint);
        return this;
    }

    public NodeBuilder<N> setEffect(Effect effect) {
        this.node.setEffect(effect);
        return this;
    }

    public NodeBuilder<N> setDisable(boolean disable) {
        this.node.setDisable(disable);
        return this;
    }

    public NodeBuilder<N> setManaged(boolean managed) {
        this.node.setManaged(managed);
        return this;
    }

    public NodeBuilder<N> relocate(double x, double y) {
        this.node.relocate(x, y);
        return this;
    }

    public NodeBuilder<N> resize(double width, double height) {
        this.node.resize(width, height);
        return this;
    }

    public NodeBuilder<N> resizeRelocate(double x, double y, double width, double height) {
        this.node.resizeRelocate(x, y, width, height);
        return this;
    }

    public NodeBuilder<N> autosize() {
        this.node.autosize();
        return this;
    }

    public NodeBuilder<N> setViewOrder(double viewOrder) {
        this.node.setViewOrder(viewOrder);
        return this;
    }

    public NodeBuilder<N> setTranslateX(double translateX) {
        this.node.setTranslateX(translateX);
        return this;
    }

    public NodeBuilder<N> setTranslateY(double translateY) {
        this.node.setTranslateY(translateY);
        return this;
    }

    public NodeBuilder<N> setTranslateZ(double translateZ) {
        this.node.setTranslateZ(translateZ);
        return this;
    }

    public NodeBuilder<N> setScaleX(double scaleX) {
        this.node.setScaleX(scaleX);
        return this;
    }

    public NodeBuilder<N> setScaleY(double scaleY) {
        this.node.setScaleY(scaleY);
        return this;
    }

    public NodeBuilder<N> setScaleZ(double scaleZ) {
        this.node.setScaleZ(scaleZ);
        return this;
    }

    public NodeBuilder<N> setRotate(double rotate) {
        this.node.setRotate(rotate);
        return this;
    }

    public NodeBuilder<N> setNodeOrientation(NodeOrientation orientation) {
        this.node.setNodeOrientation(orientation);
        return this;
    }

    public NodeBuilder<N> setMouseTransparent(boolean mouseTransparent) {
        this.node.setMouseTransparent(mouseTransparent);
        return this;
    }

    public NodeBuilder<N> setFocusTraversable(boolean focusTraversable) {
        this.node.setFocusTraversable(focusTraversable);
        return this;
    }

    public NodeBuilder<N> requestFocus() {
        this.node.requestFocus();
        return this;
    }

    public <T extends Event> NodeBuilder<N> addEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.node.addEventHandler(eventType, eventHandler);
        return this;
    }

    public <T extends Event> NodeBuilder<N> removeEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.node.removeEventHandler(eventType, eventHandler);
        return this;
    }

    public <T extends Event> NodeBuilder<N> addEventFilter(EventType<T> eventType, EventHandler<? super T> eventFilter) {
        this.node.addEventFilter(eventType, eventFilter);
        return this;
    }

    public <T extends Event> NodeBuilder<N> removeEventFilter(EventType<T> eventType, EventHandler<? super T> eventFilter) {
        this.node.removeEventFilter(eventType, eventFilter);
        return this;
    }

    @Override
    public N getNode() {
        return this.node;
    }
}

