/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.builders.layout;

import io.github.palexdev.materialfx.builders.layout.PaneBuilder;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class VBoxBuilder
extends PaneBuilder<VBox> {
    public VBoxBuilder() {
        this(new VBox());
    }

    public VBoxBuilder(VBox pane) {
        super(pane);
    }

    public static VBoxBuilder vBox() {
        return new VBoxBuilder();
    }

    public static VBoxBuilder vBox(VBox pane) {
        return new VBoxBuilder(pane);
    }

    public VBoxBuilder setVGrow(Node child, Priority priority) {
        VBox.setVgrow((Node)child, (Priority)priority);
        return this;
    }

    public VBoxBuilder setMargin(Node child, Insets margin) {
        VBox.setMargin((Node)child, (Insets)margin);
        return this;
    }

    public VBoxBuilder clearConstraints(Node child) {
        VBox.clearConstraints((Node)child);
        return this;
    }

    public VBoxBuilder setSpacing(double spacing) {
        ((VBox)this.node).setSpacing(spacing);
        return this;
    }

    public VBoxBuilder setAlignment(Pos alignment) {
        ((VBox)this.node).setAlignment(alignment);
        return this;
    }

    public VBoxBuilder setFillWidth(boolean fillWidth) {
        ((VBox)this.node).setFillWidth(fillWidth);
        return this;
    }
}

