/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.MFXResourcesLoader;
import io.github.palexdev.materialfx.beans.properties.styleable.StyleableBooleanProperty;
import io.github.palexdev.materialfx.beans.properties.styleable.StyleableDoubleProperty;
import io.github.palexdev.materialfx.beans.properties.styleable.StyleableIntegerProperty;
import io.github.palexdev.materialfx.beans.properties.styleable.StyleableObjectProperty;
import io.github.palexdev.materialfx.controls.BoundTextField;
import io.github.palexdev.materialfx.controls.MFXContextMenu;
import io.github.palexdev.materialfx.controls.MFXContextMenuItem;
import io.github.palexdev.materialfx.controls.base.MFXMenuControl;
import io.github.palexdev.materialfx.enums.FloatMode;
import io.github.palexdev.materialfx.font.MFXFontIcon;
import io.github.palexdev.materialfx.i18n.I18N;
import io.github.palexdev.materialfx.skins.MFXTextFieldSkin;
import io.github.palexdev.materialfx.utils.StyleablePropertiesUtils;
import io.github.palexdev.materialfx.validation.MFXValidator;
import io.github.palexdev.materialfx.validation.Validated;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleablePropertyFactory;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.IndexRange;
import javafx.scene.control.Skin;
import javafx.scene.control.TextField;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.paint.Color;

public class MFXTextField
extends TextField
implements Validated,
MFXMenuControl {
    private final String STYLE_CLASS = "mfx-text-field";
    private final String STYLESHEET = MFXResourcesLoader.load("css/MFXTextField.css");
    protected final BoundTextField boundField;
    public static final Color DEFAULT_TEXT_COLOR = Color.rgb((int)0, (int)0, (int)0, (double)0.87);
    private final BooleanProperty selectable = new SimpleBooleanProperty(true);
    private final ObjectProperty<Node> leadingIcon = new SimpleObjectProperty();
    private final ObjectProperty<Node> trailingIcon = new SimpleObjectProperty();
    private final StringProperty floatingText = new SimpleStringProperty();
    protected final BooleanProperty floating = new SimpleBooleanProperty(){

        public void unbind() {
        }
    };
    private static final PseudoClass FLOATING_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"floating");
    private final StringProperty measureUnit = new SimpleStringProperty("");
    protected final MFXValidator validator = new MFXValidator();
    protected MFXContextMenu contextMenu;
    private final StyleableBooleanProperty allowEdit = new StyleableBooleanProperty(StyleableProperties.EDITABLE, this, "allowEdit", true);
    private final StyleableBooleanProperty animated = new StyleableBooleanProperty(StyleableProperties.ANIMATED, this, "animated", true);
    private final StyleableDoubleProperty borderGap = new StyleableDoubleProperty(StyleableProperties.BORDER_GAP, this, "borderGap", 10.0);
    private final StyleableBooleanProperty caretVisible = new StyleableBooleanProperty(StyleableProperties.CARET_VISIBLE, this, "caretAnimated", true);
    private final StyleableObjectProperty<FloatMode> floatMode = new StyleableObjectProperty<FloatMode>(StyleableProperties.FLOAT_MODE, this, "floatMode", FloatMode.INLINE);
    private final StyleableDoubleProperty floatingTextGap = new StyleableDoubleProperty(StyleableProperties.FLOATING_TEXT_GAP, this, "gap", 5.0);
    private final StyleableDoubleProperty graphicTextGap = new StyleableDoubleProperty(StyleableProperties.GRAPHIC_TEXT_GAP, this, "graphicTextGap", 10.0);
    private final StyleableDoubleProperty measureUnitGap = new StyleableDoubleProperty(StyleableProperties.MEASURE_UNIT_GAP, this, "measureUnitGap", 5.0);
    private final StyleableBooleanProperty scaleOnAbove = new StyleableBooleanProperty(StyleableProperties.SCALE_ON_ABOVE, this, "scaleOnAbove", false);
    private final StyleableObjectProperty<Color> textFill = new StyleableObjectProperty<Color>(StyleableProperties.TEXT_FILL, this, "textFill", DEFAULT_TEXT_COLOR);
    private final StyleableIntegerProperty textLimit = new StyleableIntegerProperty(StyleableProperties.TEXT_LIMIT, this, "textLimit", -1);

    public MFXTextField() {
        this("");
    }

    public MFXTextField(String text) {
        this(text, "");
    }

    public MFXTextField(String text, String promptText) {
        this(text, promptText, "");
    }

    public MFXTextField(String text, String promptText, String floatingText) {
        super(text);
        this.boundField = new BoundTextField(this);
        this.setPromptText(promptText);
        this.setFloatingText(floatingText);
        this.initialize();
    }

    public static MFXTextField asLabel() {
        return MFXTextField.asLabel("");
    }

    public static MFXTextField asLabel(String text) {
        return MFXTextField.asLabel(text, "");
    }

    public static MFXTextField asLabel(String text, String promptText) {
        return MFXTextField.asLabel(text, promptText, "");
    }

    public static MFXTextField asLabel(String text, String promptText, String floatingText) {
        MFXTextField textField = new MFXTextField(text, promptText, floatingText);
        textField.setEditable(false);
        textField.setSelectable(false);
        return textField;
    }

    private void initialize() {
        this.getStyleClass().setAll((Object[])new String[]{"mfx-text-field"});
        this.setPrefColumnCount(6);
        this.floating.addListener(invalidated -> this.pseudoClassStateChanged(FLOATING_PSEUDO_CLASS, this.floating.get()));
        this.allowEditProperty().bindBidirectional((Property)this.editableProperty());
        this.addEventFilter(ContextMenuEvent.CONTEXT_MENU_REQUESTED, Event::consume);
        this.defaultContextMenu();
    }

    public void defaultContextMenu() {
        MFXContextMenuItem copyItem = MFXContextMenuItem.Builder.build().setIcon((Node)new MFXFontIcon("mfx-content-copy", 14.0)).setText(I18N.getOrDefault("textField.contextMenu.copy", new Object[0])).setAccelerator("Ctrl + C").setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> this.copy())).get();
        MFXContextMenuItem cutItem = MFXContextMenuItem.Builder.build().setIcon((Node)new MFXFontIcon("mfx-content-cut", 14.0)).setText(I18N.getOrDefault("textField.contextMenu.cut", new Object[0])).setAccelerator("Ctrl + X").setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> this.cut())).get();
        MFXContextMenuItem pasteItem = MFXContextMenuItem.Builder.build().setIcon((Node)new MFXFontIcon("mfx-content-paste", 14.0)).setText(I18N.getOrDefault("textField.contextMenu.paste", new Object[0])).setAccelerator("Ctrl + V").setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> this.paste())).get();
        MFXContextMenuItem deleteItem = MFXContextMenuItem.Builder.build().setIcon((Node)new MFXFontIcon("mfx-delete-alt", 16.0)).setText(I18N.getOrDefault("textField.contextMenu.delete", new Object[0])).setAccelerator("Ctrl + D").setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> this.deleteText(this.getSelection()))).get();
        MFXContextMenuItem selectAllItem = MFXContextMenuItem.Builder.build().setIcon((Node)new MFXFontIcon("mfx-select-all", 16.0)).setText(I18N.getOrDefault("textField.contextMenu.selectAll", new Object[0])).setAccelerator("Ctrl + A").setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> this.selectAll())).get();
        MFXContextMenuItem redoItem = MFXContextMenuItem.Builder.build().setIcon((Node)new MFXFontIcon("mfx-redo", 12.0)).setText(I18N.getOrDefault("textField.contextMenu.redo", new Object[0])).setAccelerator("Ctrl + Y").setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> this.redo())).get();
        MFXContextMenuItem undoItem = MFXContextMenuItem.Builder.build().setIcon((Node)new MFXFontIcon("mfx-undo", 12.0)).setText(I18N.getOrDefault("textField.contextMenu.undo", new Object[0])).setAccelerator("Ctrl + Z").setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> this.undo())).get();
        this.contextMenu = MFXContextMenu.Builder.build((Node)this).addItems(copyItem, cutItem, pasteItem, deleteItem, selectAllItem).addLineSeparator().addItems(redoItem, undoItem).setPopupStyleableParent((Parent)this).installAndGet();
    }

    @Override
    public MFXContextMenu getMFXContextMenu() {
        return this.contextMenu;
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXTextFieldSkin(this, this.boundField);
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return MFXTextField.getClassCssMetaData();
    }

    public String getUserAgentStylesheet() {
        return this.STYLESHEET;
    }

    public void cut() {
        this.boundField.cut();
    }

    public void copy() {
        this.boundField.copy();
    }

    public void paste() {
        this.boundField.paste();
    }

    public void selectBackward() {
        this.boundField.selectBackward();
    }

    public void selectForward() {
        this.boundField.selectForward();
    }

    public void previousWord() {
        this.boundField.previousWord();
    }

    public void nextWord() {
        this.boundField.nextWord();
    }

    public void endOfNextWord() {
        this.boundField.endOfNextWord();
    }

    public void selectPreviousWord() {
        this.boundField.selectPreviousWord();
    }

    public void selectNextWord() {
        this.boundField.selectNextWord();
    }

    public void selectEndOfNextWord() {
        this.boundField.selectEndOfNextWord();
    }

    public void selectAll() {
        this.boundField.selectAll();
    }

    public void home() {
        this.boundField.home();
    }

    public void end() {
        this.boundField.end();
    }

    public void selectHome() {
        this.boundField.selectHome();
    }

    public void selectEnd() {
        this.boundField.selectEnd();
    }

    public void forward() {
        this.boundField.forward();
    }

    public void backward() {
        this.boundField.backward();
    }

    public void positionCaret(int pos) {
        this.boundField.positionCaret(pos);
    }

    public void selectPositionCaret(int pos) {
        this.boundField.selectPositionCaret(pos);
    }

    public void selectRange(int anchor, int caretPosition) {
        this.boundField.selectRange(anchor, caretPosition);
    }

    public void extendSelection(int pos) {
        this.boundField.extendSelection(pos);
    }

    public void clear() {
        this.boundField.clear();
    }

    public void deselect() {
        this.boundField.deselect();
    }

    public void replaceSelection(String replacement) {
        this.boundField.replaceSelection(replacement);
    }

    public int delegateGetAnchor() {
        return this.boundField.getAnchor();
    }

    public ReadOnlyIntegerProperty delegateAnchorProperty() {
        return this.boundField.anchorProperty();
    }

    public int delegateGetCaretPosition() {
        return this.boundField.getCaretPosition();
    }

    public ReadOnlyIntegerProperty delegateCaretPositionProperty() {
        return this.boundField.caretPositionProperty();
    }

    public String delegateGetSelectedText() {
        return this.boundField.getSelectedText();
    }

    public ReadOnlyStringProperty delegateSelectedTextProperty() {
        return this.boundField.selectedTextProperty();
    }

    public IndexRange delegateGetSelection() {
        return this.boundField.getSelection();
    }

    public ReadOnlyObjectProperty<IndexRange> delegateSelectionProperty() {
        return this.boundField.selectionProperty();
    }

    public boolean delegateIsRedoable() {
        return this.boundField.isRedoable();
    }

    public ReadOnlyBooleanProperty delegateRedoableProperty() {
        return this.boundField.redoableProperty();
    }

    public boolean delegateIsUndoable() {
        return this.boundField.isUndoable();
    }

    public ReadOnlyBooleanProperty delegateUndoableProperty() {
        return this.boundField.undoableProperty();
    }

    public boolean delegateIsFocused() {
        return this.boundField.isFocused();
    }

    public ReadOnlyBooleanProperty delegateFocusedProperty() {
        return this.boundField.focusedProperty();
    }

    @Override
    public MFXValidator getValidator() {
        return this.validator;
    }

    public boolean isSelectable() {
        return this.selectable.get();
    }

    public BooleanProperty selectableProperty() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable.set(selectable);
    }

    public Node getLeadingIcon() {
        return (Node)this.leadingIcon.get();
    }

    public ObjectProperty<Node> leadingIconProperty() {
        return this.leadingIcon;
    }

    public void setLeadingIcon(Node leadingIcon) {
        this.leadingIcon.set((Object)leadingIcon);
    }

    public Node getTrailingIcon() {
        return (Node)this.trailingIcon.get();
    }

    public ObjectProperty<Node> trailingIconProperty() {
        return this.trailingIcon;
    }

    public void setTrailingIcon(Node trailingIcon) {
        this.trailingIcon.set((Object)trailingIcon);
    }

    public String getFloatingText() {
        return (String)this.floatingText.get();
    }

    public StringProperty floatingTextProperty() {
        return this.floatingText;
    }

    public void setFloatingText(String floatingText) {
        this.floatingText.set((Object)floatingText);
    }

    public boolean isFloating() {
        return this.floating.get();
    }

    public BooleanProperty floatingProperty() {
        return this.floating;
    }

    public String getMeasureUnit() {
        return (String)this.measureUnit.get();
    }

    public StringProperty measureUnitProperty() {
        return this.measureUnit;
    }

    public void setMeasureUnit(String measureUnit) {
        this.measureUnit.set((Object)measureUnit);
    }

    public boolean isAllowEdit() {
        return this.allowEdit.get();
    }

    public StyleableBooleanProperty allowEditProperty() {
        return this.allowEdit;
    }

    public void setAllowEdit(boolean allowEdit) {
        this.allowEdit.set(allowEdit);
    }

    public boolean isAnimated() {
        return this.animated.get();
    }

    public StyleableBooleanProperty animatedProperty() {
        return this.animated;
    }

    public void setAnimated(boolean animated) {
        this.animated.set(animated);
    }

    public double getBorderGap() {
        return this.borderGap.get();
    }

    public StyleableDoubleProperty borderGapProperty() {
        return this.borderGap;
    }

    public void setBorderGap(double borderGap) {
        this.borderGap.set(borderGap);
    }

    public boolean getCaretVisible() {
        return this.caretVisible.get();
    }

    public StyleableBooleanProperty caretVisibleProperty() {
        return this.caretVisible;
    }

    public void setCaretVisible(boolean caretVisible) {
        this.caretVisible.set(caretVisible);
    }

    public FloatMode getFloatMode() {
        return (FloatMode)((Object)this.floatMode.get());
    }

    public StyleableObjectProperty<FloatMode> floatModeProperty() {
        return this.floatMode;
    }

    public void setFloatMode(FloatMode floatMode) {
        this.floatMode.set((Object)floatMode);
    }

    public double getFloatingTextGap() {
        return this.floatingTextGap.get();
    }

    public StyleableDoubleProperty floatingTextGapProperty() {
        return this.floatingTextGap;
    }

    public void setFloatingTextGap(double floatingTextGap) {
        this.floatingTextGap.set(floatingTextGap);
    }

    public double getGraphicTextGap() {
        return this.graphicTextGap.get();
    }

    public StyleableDoubleProperty graphicTextGapProperty() {
        return this.graphicTextGap;
    }

    public void setGraphicTextGap(double graphicTextGap) {
        this.graphicTextGap.set(graphicTextGap);
    }

    public boolean scaleOnAbove() {
        return this.scaleOnAbove.get();
    }

    public StyleableBooleanProperty scaleOnAboveProperty() {
        return this.scaleOnAbove;
    }

    public void setScaleOnAbove(boolean scaleOnAbove) {
        this.scaleOnAbove.set(scaleOnAbove);
    }

    public double getMeasureUnitGap() {
        return this.measureUnitGap.get();
    }

    public StyleableDoubleProperty measureUnitGapProperty() {
        return this.measureUnitGap;
    }

    public void setMeasureUnitGap(double measureUnitGap) {
        this.measureUnitGap.set(measureUnitGap);
    }

    public Color getTextFill() {
        return (Color)this.textFill.get();
    }

    public StyleableObjectProperty<Color> textFillProperty() {
        return this.textFill;
    }

    public void setTextFill(Color textFill) {
        this.textFill.set(textFill);
    }

    public int getTextLimit() {
        return this.textLimit.get();
    }

    public StyleableIntegerProperty textLimitProperty() {
        return this.textLimit;
    }

    public void setTextLimit(int textLimit) {
        this.textLimit.set(textLimit);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.cssMetaDataList;
    }

    private static class StyleableProperties {
        private static final StyleablePropertyFactory<MFXTextField> FACTORY = new StyleablePropertyFactory(TextField.getClassCssMetaData());
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<MFXTextField, Boolean> ANIMATED;
        private static final CssMetaData<MFXTextField, Number> BORDER_GAP;
        private static final CssMetaData<MFXTextField, Boolean> CARET_VISIBLE;
        private static final CssMetaData<MFXTextField, Boolean> EDITABLE;
        private static final CssMetaData<MFXTextField, FloatMode> FLOAT_MODE;
        private static final CssMetaData<MFXTextField, Number> FLOATING_TEXT_GAP;
        private static final CssMetaData<MFXTextField, Number> GRAPHIC_TEXT_GAP;
        private static final CssMetaData<MFXTextField, Number> MEASURE_UNIT_GAP;
        private static final CssMetaData<MFXTextField, Boolean> SCALE_ON_ABOVE;
        private static final CssMetaData<MFXTextField, Color> TEXT_FILL;
        private static final CssMetaData<MFXTextField, Number> TEXT_LIMIT;

        private StyleableProperties() {
        }

        static {
            ANIMATED = FACTORY.createBooleanCssMetaData("-mfx-animated", MFXTextField::animatedProperty, true);
            BORDER_GAP = FACTORY.createSizeCssMetaData("-mfx-border-gap", MFXTextField::borderGapProperty, (Number)10.0);
            CARET_VISIBLE = FACTORY.createBooleanCssMetaData("-mfx-caret-visible", MFXTextField::caretVisibleProperty, true);
            EDITABLE = FACTORY.createBooleanCssMetaData("-mfx-editable", MFXTextField::allowEditProperty, true);
            FLOAT_MODE = FACTORY.createEnumCssMetaData(FloatMode.class, "-mfx-float-mode", MFXTextField::floatModeProperty, (Enum)FloatMode.INLINE);
            FLOATING_TEXT_GAP = FACTORY.createSizeCssMetaData("-mfx-gap", MFXTextField::floatingTextGapProperty, (Number)5.0);
            GRAPHIC_TEXT_GAP = FACTORY.createSizeCssMetaData("-fx-graphic-text-gap", MFXTextField::graphicTextGapProperty, (Number)10.0);
            MEASURE_UNIT_GAP = FACTORY.createSizeCssMetaData("-mfx-measure-unit-gap", MFXTextField::measureUnitGapProperty, (Number)5.0);
            SCALE_ON_ABOVE = FACTORY.createBooleanCssMetaData("-mfx-scale-on-above", MFXTextField::scaleOnAboveProperty, false);
            TEXT_FILL = FACTORY.createColorCssMetaData("-fx-text-fill", MFXTextField::textFillProperty, DEFAULT_TEXT_COLOR);
            TEXT_LIMIT = FACTORY.createSizeCssMetaData("-mfx-text-limit", MFXTextField::textLimitProperty, (Number)-1);
            cssMetaDataList = StyleablePropertiesUtils.cssMetaDataList(TextField.getClassCssMetaData(), ANIMATED, CARET_VISIBLE, BORDER_GAP, EDITABLE, FLOAT_MODE, FLOATING_TEXT_GAP, GRAPHIC_TEXT_GAP, MEASURE_UNIT_GAP, SCALE_ON_ABOVE, TEXT_FILL, TEXT_LIMIT);
        }
    }
}

