/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.MFXResourcesLoader;
import io.github.palexdev.materialfx.controls.MFXScrollPane;
import io.github.palexdev.materialfx.controls.MFXTreeItem;
import io.github.palexdev.materialfx.controls.base.AbstractMFXTreeItem;
import io.github.palexdev.materialfx.factories.InsetsFactory;
import io.github.palexdev.materialfx.selection.TreeSelectionModel;
import io.github.palexdev.materialfx.selection.base.ITreeSelectionModel;
import io.github.palexdev.materialfx.utils.NodeUtils;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.scene.Node;

public class MFXTreeView<T>
extends MFXScrollPane {
    private final String STYLE_CLASS = "mfx-tree-view";
    private final String STYLESHEET = MFXResourcesLoader.load("css/MFXTreeView.css");
    private final ObjectProperty<AbstractMFXTreeItem<T>> root = new SimpleObjectProperty(null);
    private final ObjectProperty<ITreeSelectionModel<T>> selectionModel = new SimpleObjectProperty(null);
    private final BooleanProperty showRoot = new SimpleBooleanProperty(true);

    public MFXTreeView() {
        this.installSelectionModel();
        this.initialize();
    }

    public MFXTreeView(MFXTreeItem<T> root) {
        this.installSelectionModel();
        root.setTreeView(this);
        this.setRoot(root);
        this.setContent((Node)root);
        this.initialize();
    }

    protected void initialize() {
        this.getStyleClass().add((Object)"mfx-tree-view");
        this.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.setPrefSize(250.0, 500.0);
        AbstractMFXTreeItem root = this.getRoot();
        this.rootProperty().addListener((observable, oldRoot, newRoot) -> {
            newRoot.setTreeView(this);
            this.setContent((Node)newRoot);
            this.setupRoot();
        });
        if (root != null) {
            this.setupRoot();
        }
        this.showRoot.addListener((observable, oldValue, newValue) -> {
            if (root != null) {
                root.fireEvent(new TreeViewEvent((EventType<? extends Event>)TreeViewEvent.HIDE_ROOT_EVENT, (boolean)newValue));
            }
        });
    }

    public void setupRoot() {
        AbstractMFXTreeItem<T> root = this.getRoot();
        root.prefWidthProperty().bind((ObservableValue)this.widthProperty().subtract(10));
        root.setPadding(InsetsFactory.bottom(5.0));
        NodeUtils.waitForSkin(root, () -> {
            if (!this.isShowRoot()) {
                root.fireEvent(new TreeViewEvent(TreeViewEvent.HIDE_ROOT_EVENT, this.isShowRoot()));
            }
        }, true, true);
    }

    protected void installSelectionModel() {
        TreeSelectionModel selectionModel = new TreeSelectionModel();
        selectionModel.setAllowsMultipleSelection(true);
        this.setSelectionModel(selectionModel);
    }

    public AbstractMFXTreeItem<T> getRoot() {
        return (AbstractMFXTreeItem)((Object)this.root.get());
    }

    public ObjectProperty<AbstractMFXTreeItem<T>> rootProperty() {
        return this.root;
    }

    public void setRoot(AbstractMFXTreeItem<T> root) {
        this.root.set(root);
    }

    public ITreeSelectionModel<T> getSelectionModel() {
        return (ITreeSelectionModel)this.selectionModel.get();
    }

    public ObjectProperty<ITreeSelectionModel<T>> selectionModelProperty() {
        return this.selectionModel;
    }

    public void setSelectionModel(ITreeSelectionModel<T> selectionModel) {
        this.selectionModel.set(selectionModel);
    }

    public boolean isShowRoot() {
        return this.showRoot.get();
    }

    public void setShowRoot(boolean showRoot) {
        this.showRoot.set(showRoot);
    }

    @Override
    public String getUserAgentStylesheet() {
        return this.STYLESHEET;
    }

    public static class TreeViewEvent
    extends Event {
        private final boolean show;
        public static final EventType<TreeViewEvent> HIDE_ROOT_EVENT = new EventType(ANY, "HIDE_ROOT_EVENT");

        public TreeViewEvent(EventType<? extends Event> eventType, boolean show) {
            super(eventType);
            this.show = show;
        }

        public boolean isShow() {
            return this.show;
        }
    }
}

