/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls.base;

import io.github.palexdev.materialfx.controls.base.IListView;
import io.github.palexdev.materialfx.effects.DepthLevel;
import io.github.palexdev.materialfx.selection.MultipleSelectionModel;
import io.github.palexdev.materialfx.selection.base.IMultipleSelectionModel;
import io.github.palexdev.materialfx.utils.ColorUtils;
import io.github.palexdev.materialfx.utils.StyleablePropertiesUtils;
import io.github.palexdev.virtualizedfx.cell.Cell;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.scene.control.Control;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import javafx.util.StringConverter;

public abstract class AbstractMFXListView<T, C extends Cell<T>>
extends Control
implements IListView<T, C> {
    protected final ObjectProperty<ObservableList<T>> items = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
    protected final ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty();
    protected final IMultipleSelectionModel<T> selectionModel = new MultipleSelectionModel<T>(this.items);
    private final ObjectProperty<Paint> trackColor = new SimpleObjectProperty((Object)Color.rgb((int)230, (int)230, (int)230));
    private final ObjectProperty<Paint> thumbColor = new SimpleObjectProperty((Object)Color.rgb((int)137, (int)137, (int)137));
    private final ObjectProperty<Paint> thumbHoverColor = new SimpleObjectProperty((Object)Color.rgb((int)89, (int)88, (int)91));
    private final ObjectProperty<Duration> hideAfter = new SimpleObjectProperty((Object)Duration.seconds((double)1.0));
    private final StyleableBooleanProperty hideScrollBars = new SimpleStyleableBooleanProperty(StyleableProperties.HIDE_SCROLLBARS, (Object)this, "hideScrollBars", false);
    private final StyleableObjectProperty<DepthLevel> depthLevel = new SimpleStyleableObjectProperty(StyleableProperties.DEPTH_LEVEL, (Object)this, "depthLevel", (Object)DepthLevel.LEVEL2);

    public AbstractMFXListView() {
    }

    public AbstractMFXListView(ObservableList<T> items) {
        this.setItems(items);
    }

    protected abstract void setDefaultCellFactory();

    protected void initialize() {
        this.setDefaultCellFactory();
        this.addBarsListeners();
    }

    protected void addBarsListeners() {
        this.trackColor.addListener((observable, oldValue, newValue) -> {
            if (!newValue.equals(oldValue)) {
                this.setColors();
            }
        });
        this.thumbColor.addListener((observable, oldValue, newValue) -> {
            if (!newValue.equals(oldValue)) {
                this.setColors();
            }
        });
        this.thumbHoverColor.addListener((observable, oldValue, newValue) -> {
            if (!newValue.equals(oldValue)) {
                this.setColors();
            }
        });
    }

    protected void setColors() {
        StringBuilder sb = new StringBuilder();
        sb.append("-mfx-track-color: ").append(ColorUtils.toCss((Paint)this.trackColor.get())).append(";\n-mfx-thumb-color: ").append(ColorUtils.toCss((Paint)this.thumbColor.get())).append(";\n-mfx-thumb-hover-color: ").append(ColorUtils.toCss((Paint)this.thumbHoverColor.get())).append(";");
        this.setStyle(sb.toString());
    }

    public Paint getTrackColor() {
        return (Paint)this.trackColor.get();
    }

    public ObjectProperty<Paint> trackColorProperty() {
        return this.trackColor;
    }

    public void setTrackColor(Paint trackColor) {
        this.trackColor.set((Object)trackColor);
    }

    public Paint getThumbColor() {
        return (Paint)this.thumbColor.get();
    }

    public ObjectProperty<Paint> thumbColorProperty() {
        return this.thumbColor;
    }

    public void setThumbColor(Paint thumbColor) {
        this.thumbColor.set((Object)thumbColor);
    }

    public Paint getThumbHoverColor() {
        return (Paint)this.thumbHoverColor.get();
    }

    public ObjectProperty<Paint> thumbHoverColorProperty() {
        return this.thumbHoverColor;
    }

    public void setThumbHoverColor(Paint thumbHoverColor) {
        this.thumbHoverColor.set((Object)thumbHoverColor);
    }

    public Duration getHideAfter() {
        return (Duration)this.hideAfter.get();
    }

    public ObjectProperty<Duration> hideAfterProperty() {
        return this.hideAfter;
    }

    public void setHideAfter(Duration hideAfter) {
        this.hideAfter.set((Object)hideAfter);
    }

    @Override
    public ObservableList<T> getItems() {
        return (ObservableList)this.items.get();
    }

    @Override
    public ObjectProperty<ObservableList<T>> itemsProperty() {
        return this.items;
    }

    @Override
    public void setItems(ObservableList<T> items) {
        this.items.set(items);
    }

    @Override
    public StringConverter<T> getConverter() {
        return (StringConverter)this.converter.get();
    }

    @Override
    public ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    @Override
    public void setConverter(StringConverter<T> converter) {
        this.converter.set(converter);
    }

    @Override
    public IMultipleSelectionModel<T> getSelectionModel() {
        return this.selectionModel;
    }

    public boolean isHideScrollBars() {
        return this.hideScrollBars.get();
    }

    public StyleableBooleanProperty hideScrollBarsProperty() {
        return this.hideScrollBars;
    }

    public void setHideScrollBars(boolean hideScrollBars) {
        this.hideScrollBars.set(hideScrollBars);
    }

    public DepthLevel getDepthLevel() {
        return (DepthLevel)((Object)this.depthLevel.get());
    }

    public StyleableObjectProperty<DepthLevel> depthLevelProperty() {
        return this.depthLevel;
    }

    public void setDepthLevel(DepthLevel depthLevel) {
        this.depthLevel.set((Object)depthLevel);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.cssMetaDataList;
    }

    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return AbstractMFXListView.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final StyleablePropertyFactory<AbstractMFXListView<?, ?>> FACTORY = new StyleablePropertyFactory(Control.getClassCssMetaData());
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<AbstractMFXListView<?, ?>, Boolean> HIDE_SCROLLBARS;
        private static final CssMetaData<AbstractMFXListView<?, ?>, DepthLevel> DEPTH_LEVEL;

        private StyleableProperties() {
        }

        static {
            HIDE_SCROLLBARS = FACTORY.createBooleanCssMetaData("-mfx-hide-scrollbars", AbstractMFXListView::hideScrollBarsProperty, false);
            DEPTH_LEVEL = FACTORY.createEnumCssMetaData(DepthLevel.class, "-mfx-depth-level", AbstractMFXListView::depthLevelProperty, (Enum)DepthLevel.LEVEL2);
            cssMetaDataList = StyleablePropertiesUtils.cssMetaDataList(Control.getClassCssMetaData(), HIDE_SCROLLBARS, DEPTH_LEVEL);
        }
    }
}

