/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.css;

import java.util.Collection;
import javafx.beans.InvalidationListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Parent;
import javafx.scene.layout.Region;

public class MFXCSSBridge {
    private Parent parent;
    private final ObservableList<String> stylesheets = FXCollections.observableArrayList();
    private final InvalidationListener stylesheetsChanged = invalidated -> this.initializeStylesheets();

    public MFXCSSBridge(Parent parent) {
        this.parent = parent;
        this.initializeStylesheets();
        this.addListeners();
    }

    public void initializeStylesheets() {
        Region region;
        this.stylesheets.clear();
        if (this.parent == null) {
            return;
        }
        if (this.parent instanceof Region && (region = (Region)this.parent).getUserAgentStylesheet() != null && !region.getUserAgentStylesheet().isEmpty()) {
            this.stylesheets.add((Object)region.getUserAgentStylesheet());
        }
        this.stylesheets.addAll((Collection)this.parent.getStylesheets());
    }

    public void addListeners() {
        if (this.parent == null) {
            return;
        }
        this.parent.getStylesheets().addListener(this.stylesheetsChanged);
    }

    public void dispose() {
        if (this.parent != null) {
            this.parent.getStylesheets().removeListener(this.stylesheetsChanged);
        }
    }

    public Parent getParent() {
        return this.parent;
    }

    public void setParent(Parent parent) {
        this.parent = parent;
    }

    public ObservableList<String> getStylesheets() {
        return this.stylesheets;
    }
}

