/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.filter;

import io.github.palexdev.materialfx.beans.BiPredicateBean;
import io.github.palexdev.materialfx.filter.base.NumberFilter;
import io.github.palexdev.materialfx.i18n.I18N;
import io.github.palexdev.materialfx.utils.FXCollectors;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Stream;
import javafx.collections.ObservableList;
import javafx.util.StringConverter;
import javafx.util.converter.FloatStringConverter;

public class FloatFilter<T>
extends NumberFilter<T, Float> {
    public FloatFilter(String name, Function<T, Float> extractor) {
        this(name, extractor, (StringConverter<Float>)new FloatStringConverter());
    }

    public FloatFilter(String name, Function<T, Float> extractor, StringConverter<Float> converter) {
        super(name, extractor, converter);
    }

    @Override
    protected ObservableList<BiPredicateBean<Float, Float>> defaultPredicates() {
        return Stream.of(new BiPredicateBean<Float, Float>(I18N.getOrDefault("filter.is", new Object[0]), Float::equals), new BiPredicateBean<Float, Float>(I18N.getOrDefault("filter.isNot", new Object[0]), (aFloat, aFloat2) -> !aFloat.equals(aFloat2)), new BiPredicateBean<Float, Float>(I18N.getOrDefault("filter.greater", new Object[0]), (aFloat, aFloat2) -> aFloat.floatValue() > aFloat2.floatValue()), new BiPredicateBean<Float, Float>(I18N.getOrDefault("filter.greaterEqual", new Object[0]), (aFloat, aFloat2) -> aFloat.floatValue() >= aFloat2.floatValue()), new BiPredicateBean<Float, Float>(I18N.getOrDefault("filter.lesser", new Object[0]), (aFloat, aFloat2) -> aFloat.floatValue() < aFloat2.floatValue()), new BiPredicateBean<Float, Float>(I18N.getOrDefault("filter.lesserEqual", new Object[0]), (aFloat, aFloat2) -> aFloat.floatValue() <= aFloat2.floatValue())).collect(FXCollectors.toList());
    }

    @SafeVarargs
    protected final FloatFilter<T> extend(BiPredicateBean<Float, Float> ... predicateBeans) {
        Collections.addAll(this.predicates, predicateBeans);
        return this;
    }
}

