/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins.legacy;

import io.github.palexdev.materialfx.controls.legacy.MFXLegacyListView;
import io.github.palexdev.materialfx.effects.MFXDepthManager;
import io.github.palexdev.materialfx.factories.MFXAnimationFactory;
import io.github.palexdev.materialfx.utils.AnimationUtils;
import java.util.Set;
import javafx.animation.Animation;
import javafx.animation.KeyValue;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.skin.ListViewSkin;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.effect.Effect;
import javafx.util.Duration;

public class MFXLegacyListViewSkin<T>
extends ListViewSkin<T> {
    private final VirtualFlow<?> virtualFlow;
    private final ScrollBar vBar;
    private final ScrollBar hBar;
    private final Animation hideBars;
    private final Animation showBars;

    public MFXLegacyListViewSkin(MFXLegacyListView<T> listView) {
        super(listView);
        this.virtualFlow = (VirtualFlow)listView.lookup(".virtual-flow");
        listView.setEffect((Effect)MFXDepthManager.shadowOf(listView.getDepthLevel()));
        this.vBar = new ScrollBar();
        this.hBar = new ScrollBar();
        this.bindScrollBars(listView);
        this.getChildren().addAll((Object[])new Node[]{this.vBar, this.hBar});
        this.vBar.setManaged(false);
        this.vBar.setOrientation(Orientation.VERTICAL);
        this.vBar.getStyleClass().add((Object)"mfx-scroll-bar");
        this.hBar.setManaged(false);
        this.hBar.setOrientation(Orientation.HORIZONTAL);
        this.hBar.getStyleClass().add((Object)"mfx-scroll-bar");
        this.hideBars = AnimationUtils.TimelineBuilder.build().add(AnimationUtils.KeyFrames.of(Duration.millis((double)400.0), new KeyValue((WritableValue)this.vBar.opacityProperty(), (Object)0.0, MFXAnimationFactory.INTERPOLATOR_V1), new KeyValue((WritableValue)this.hBar.opacityProperty(), (Object)0.0, MFXAnimationFactory.INTERPOLATOR_V1))).getAnimation();
        this.showBars = AnimationUtils.TimelineBuilder.build().add(AnimationUtils.KeyFrames.of(Duration.millis((double)400.0), new KeyValue((WritableValue)this.vBar.opacityProperty(), (Object)1.0, MFXAnimationFactory.INTERPOLATOR_V1), new KeyValue((WritableValue)this.hBar.opacityProperty(), (Object)1.0, MFXAnimationFactory.INTERPOLATOR_V1))).getAnimation();
        if (listView.isHideScrollBars()) {
            this.vBar.setOpacity(0.0);
            this.hBar.setOpacity(0.0);
        }
        this.setListeners();
    }

    private void setListeners() {
        MFXLegacyListView listView = (MFXLegacyListView)this.getSkinnable();
        listView.setOnMouseExited(event -> {
            if (listView.isHideScrollBars()) {
                this.hideBars.setDelay(listView.getHideAfter());
                if (this.hBar.isPressed()) {
                    this.hBar.pressedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                            if (!newValue.booleanValue()) {
                                MFXLegacyListViewSkin.this.hideBars.play();
                            }
                            MFXLegacyListViewSkin.this.hBar.pressedProperty().removeListener((ChangeListener)this);
                        }
                    });
                    return;
                }
                if (this.vBar.isPressed()) {
                    this.vBar.pressedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                            if (!newValue.booleanValue()) {
                                MFXLegacyListViewSkin.this.hideBars.play();
                            }
                            MFXLegacyListViewSkin.this.vBar.pressedProperty().removeListener((ChangeListener)this);
                        }
                    });
                    return;
                }
                this.hideBars.play();
            }
        });
        listView.setOnMouseEntered(event -> {
            if (this.hideBars.getStatus().equals((Object)Animation.Status.RUNNING)) {
                this.hideBars.stop();
            }
            this.showBars.play();
        });
        listView.hideScrollBarsProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.hideBars.play();
            } else {
                this.showBars.play();
            }
            if (newValue.booleanValue() && this.hideBars.getStatus() != Animation.Status.RUNNING || this.vBar.getOpacity() != 0.0 || this.hBar.getOpacity() != 0.0) {
                this.vBar.setOpacity(0.0);
                this.hBar.setOpacity(0.0);
            }
        });
        listView.depthLevelProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.equals(oldValue)) {
                listView.setEffect((Effect)MFXDepthManager.shadowOf(listView.getDepthLevel()));
            }
        });
    }

    private void bindScrollBars(MFXLegacyListView<?> listView) {
        Set nodes = listView.lookupAll("VirtualScrollBar");
        for (Node node : nodes) {
            if (!(node instanceof ScrollBar)) continue;
            ScrollBar bar = (ScrollBar)node;
            if (bar.getOrientation().equals((Object)Orientation.VERTICAL)) {
                this.bindScrollBars(this.vBar, bar);
                continue;
            }
            if (!bar.getOrientation().equals((Object)Orientation.HORIZONTAL)) continue;
            this.bindScrollBars(this.hBar, bar);
        }
    }

    private void bindScrollBars(ScrollBar scrollBarA, ScrollBar scrollBarB) {
        scrollBarA.valueProperty().bindBidirectional((Property)scrollBarB.valueProperty());
        scrollBarA.minProperty().bindBidirectional((Property)scrollBarB.minProperty());
        scrollBarA.maxProperty().bindBidirectional((Property)scrollBarB.maxProperty());
        scrollBarA.visibleAmountProperty().bindBidirectional((Property)scrollBarB.visibleAmountProperty());
        scrollBarA.unitIncrementProperty().bindBidirectional((Property)scrollBarB.unitIncrementProperty());
        scrollBarA.blockIncrementProperty().bindBidirectional((Property)scrollBarB.blockIncrementProperty());
        scrollBarA.visibleProperty().bind((ObservableValue)scrollBarB.visibleProperty());
    }

    private double estimateHeight() {
        double borderWidth = this.snapVerticalInsets();
        double cellsHeight = 0.0;
        for (int i = 0; i < this.virtualFlow.getCellCount(); ++i) {
            ListCell cell = (ListCell)this.virtualFlow.getCell(i);
            cellsHeight += cell.getHeight();
        }
        return cellsHeight + borderWidth;
    }

    private double snapVerticalInsets() {
        return ((ListView)this.getSkinnable()).snappedBottomInset() + ((ListView)this.getSkinnable()).snappedTopInset();
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return 200.0;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        int itemsCount = ((ListView)this.getSkinnable()).getItems().size();
        if (((ListView)this.getSkinnable()).maxHeightProperty().isBound() || itemsCount <= 0) {
            return super.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
        }
        double fixedCellSize = ((ListView)this.getSkinnable()).getFixedCellSize();
        double computedHeight = fixedCellSize != -1.0 ? fixedCellSize * (double)itemsCount + this.snapVerticalInsets() : this.estimateHeight();
        double height = super.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
        if (height > computedHeight) {
            height = computedHeight;
        }
        if (((ListView)this.getSkinnable()).getMaxHeight() > 0.0 && computedHeight > ((ListView)this.getSkinnable()).getMaxHeight()) {
            return ((ListView)this.getSkinnable()).getMaxHeight();
        }
        return height;
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((ListView)this.getSkinnable()).prefHeight(width);
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((ListView)this.getSkinnable()).prefWidth(height);
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        Insets insets = ((ListView)this.getSkinnable()).getInsets();
        double prefWidth = this.vBar.prefWidth(-1.0);
        this.vBar.resizeRelocate(w - prefWidth - insets.getRight(), insets.getTop(), prefWidth, h - insets.getTop() - insets.getBottom());
        double prefHeight = this.hBar.prefHeight(-1.0);
        this.hBar.resizeRelocate(insets.getLeft(), h - prefHeight - insets.getBottom(), w - insets.getLeft() - insets.getRight(), prefHeight);
    }
}

