/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins.legacy;

import java.util.Set;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.skin.TableViewSkin;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.layout.Pane;

public class MFXLegacyTableViewSkin<T>
extends TableViewSkin<T> {
    private final VirtualFlow<?> virtualFlow;
    private final Pane header;
    private final ScrollBar vBar;
    private final ScrollBar hBar;

    public MFXLegacyTableViewSkin(TableView<T> tableView) {
        super(tableView);
        this.virtualFlow = (VirtualFlow)tableView.lookup(".virtual-flow");
        this.header = (Pane)tableView.lookup("TableHeaderRow");
        this.vBar = new ScrollBar();
        this.hBar = new ScrollBar();
        this.bindScrollBars(tableView);
        this.getChildren().addAll((Object[])new Node[]{this.vBar, this.hBar});
        this.vBar.setManaged(false);
        this.vBar.setOrientation(Orientation.VERTICAL);
        this.vBar.getStyleClass().add((Object)"mfx-scroll-bar");
        this.hBar.setManaged(false);
        this.hBar.setOrientation(Orientation.HORIZONTAL);
        this.hBar.getStyleClass().add((Object)"mfx-scroll-bar");
    }

    private void bindScrollBars(TableView<?> tableView) {
        Set nodes = tableView.lookupAll("VirtualScrollBar");
        for (Node node : nodes) {
            if (!(node instanceof ScrollBar)) continue;
            ScrollBar bar = (ScrollBar)node;
            if (bar.getOrientation().equals((Object)Orientation.VERTICAL)) {
                this.bindScrollBars(this.vBar, bar);
                continue;
            }
            if (!bar.getOrientation().equals((Object)Orientation.HORIZONTAL)) continue;
            this.bindScrollBars(this.hBar, bar);
        }
    }

    private void bindScrollBars(ScrollBar scrollBarA, ScrollBar scrollBarB) {
        scrollBarA.valueProperty().bindBidirectional((Property)scrollBarB.valueProperty());
        scrollBarA.minProperty().bindBidirectional((Property)scrollBarB.minProperty());
        scrollBarA.maxProperty().bindBidirectional((Property)scrollBarB.maxProperty());
        scrollBarA.visibleAmountProperty().bindBidirectional((Property)scrollBarB.visibleAmountProperty());
        scrollBarA.unitIncrementProperty().bindBidirectional((Property)scrollBarB.unitIncrementProperty());
        scrollBarA.blockIncrementProperty().bindBidirectional((Property)scrollBarB.blockIncrementProperty());
        scrollBarA.visibleProperty().bind((ObservableValue)scrollBarB.visibleProperty());
    }

    private double estimateHeight() {
        double borderWidth = this.snapVerticalInsets();
        double cellsHeight = 0.0;
        for (int i = 0; i < this.virtualFlow.getCellCount(); ++i) {
            TableRow cell = (TableRow)this.virtualFlow.getCell(i);
            cellsHeight += cell.getHeight();
        }
        return cellsHeight + borderWidth;
    }

    private double snapVerticalInsets() {
        return ((TableView)this.getSkinnable()).snappedBottomInset() + ((TableView)this.getSkinnable()).snappedTopInset();
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        int itemsCount = ((TableView)this.getSkinnable()).getItems().size();
        if (((TableView)this.getSkinnable()).maxHeightProperty().isBound() || itemsCount <= 0) {
            return super.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
        }
        double fixedCellSize = ((TableView)this.getSkinnable()).getFixedCellSize();
        double computedHeight = fixedCellSize != -1.0 ? fixedCellSize * (double)itemsCount + this.snapVerticalInsets() : this.estimateHeight();
        double height = super.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
        if (height > computedHeight) {
            height = computedHeight;
        }
        if (((TableView)this.getSkinnable()).getMaxHeight() > 0.0 && computedHeight > ((TableView)this.getSkinnable()).getMaxHeight()) {
            return ((TableView)this.getSkinnable()).getMaxHeight();
        }
        return height;
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        double headerH = this.header.getHeight();
        Insets insets = ((TableView)this.getSkinnable()).getInsets();
        double prefWidth = this.vBar.prefWidth(-1.0);
        this.vBar.resizeRelocate(w - prefWidth - insets.getRight(), insets.getTop() + headerH, prefWidth, h - insets.getTop() - insets.getBottom() - headerH);
        double prefHeight = this.hBar.prefHeight(-1.0);
        this.hBar.resizeRelocate(insets.getLeft() + 5.0, h - prefHeight - insets.getBottom() + 20.0, w - insets.getLeft() - insets.getRight() - 20.0, prefHeight);
    }
}

