/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.utils.others.observables;

import io.github.palexdev.materialfx.utils.others.observables.OnChanged;
import io.github.palexdev.materialfx.utils.others.observables.OnInvalidated;
import java.util.WeakHashMap;
import javafx.beans.value.ObservableValue;

public abstract class When<T> {
    protected static final WeakHashMap<ObservableValue<?>, When<?>> whens = new WeakHashMap();
    protected final ObservableValue<T> observableValue;
    protected boolean oneShot = false;

    protected When(ObservableValue<T> observableValue) {
        this.observableValue = observableValue;
    }

    public abstract When<T> listen();

    public abstract void dispose();

    public boolean isOneShot() {
        return this.oneShot;
    }

    public When<T> oneShot() {
        this.oneShot = true;
        return this;
    }

    public static <T> OnInvalidated<T> onInvalidated(ObservableValue<T> observableValue) {
        return OnInvalidated.forObservable(observableValue);
    }

    public static <T> OnChanged<T> onChanged(ObservableValue<T> observableValue) {
        return OnChanged.forObservable(observableValue);
    }

    public static void disposeFor(ObservableValue<?> observableValue) {
        When<?> remove = whens.remove(observableValue);
        if (remove != null) {
            remove.dispose();
        }
    }
}

