/*
 * Copyright (C) 2022 Parisi Alessandro
 * This file is part of MaterialFX (https://github.com/palexdev/MaterialFX).
 *
 * MaterialFX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * MaterialFX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with MaterialFX.  If not, see <http://www.gnu.org/licenses/>.
 */

package io.github.palexdev.materialfx.font;

/**
 * Enumerator class for MaterialFX font resources. (Count: 132)
 */
public enum FontResources {
	ANGLE_DOWN("mfx-angle-down", '\uE900'),
	ANGLE_LEFT("mfx-angle-left", '\uE901'),
	ANGLE_RIGHT("mfx-angle-right", '\uE902'),
	ANGLE_UP("mfx-angle-up", '\uE903'),
	ARROW_BACK("mfx-arrow-back", '\uE904'),
	ARROW_FORWARD("mfx-arrow-forward", '\uE905'),
	BACK("mfx-back", '\uE906'),
	BARS("mfx-bars", '\uE907'),
	BELL("mfx-bell", '\uE908'),
	BELL_ALT("mfx-bell-alt", '\uE909'),
	CALENDAR_ALT_DARK("mfx-calendar-alt-dark", '\uE90A'),
	CALENDAR_ALT_LIGHT("mfx-calendar-alt-light", '\uE90B'),
	CALENDAR_ALT_SEMI_DARK("mfx-calendar-alt-semi-dark", '\uE90C'),
	CALENDAR_DARK("mfx-calendar-dark", '\uE90D'),
	CALENDAR_LIGHT("mfx-calendar-light", '\uE90E'),
	CALENDAR_SEMI_DARK("mfx-calendar-semi-dark", '\uE90F'),
	CALENDARS("mfx-calendars", '\uE910'),
	CALENDARS_SEMI_DARK("mfx-calendars-semi-dark", '\uE911'),
	CARET_DOWN("mfx-caret-down", '\uE912'),
	CARET_LEFT("mfx-caret-left", '\uE913'),
	CARET_RIGHT("mfx-caret-right", '\uE914'),
	CARET_UP("mfx-caret-up", '\uE915'),
	CASPIAN_MARK("mfx-caspian-mark", '\uE916'),
	CHART_PIE("mfx-chart-pie", '\uE917'),
	CHECK_CIRCLE("mfx-check-circle", '\uE918'),
	CHECK_CIRCLE_EMPTY("mfx-check-circle-empty", '\uE919'),
	CHEVRON_DOWN("mfx-chevron-down", '\uE91A'),
	CHEVRON_LEFT("mfx-chevron-left", '\uE91B'),
	CHEVRON_RIGHT("mfx-chevron-right", '\uE91C'),
	CHEVRON_UP("mfx-chevron-up", '\uE91D'),
	CIRCLE("mfx-circle", '\uE91E'),
	CIRCLE_DOT("mfx-circle-dot", '\uE91F'),
	CIRCLE_EMPTY("mfx-circle-empty", '\uE920'),
	CONTENT_COPY("mfx-content-copy", '\uE921'),
	CONTENT_CUT("mfx-content-cut", '\uE922'),
	CONTENT_PASTE("mfx-content-paste", '\uE923'),
	DASHBOARD("mfx-dashboard", '\uE924'),
	DEBUG("mfx-debug", '\uE925'),
	DELETE("mfx-delete", '\uE926'),
	DELETE_ALT("mfx-delete-alt", '\uE927'),
	DO_NOT_ENTER_CIRCLE("mfx-do-not-enter-circle", '\uE928'),
	ELLIPSIS_VERTICAL("mfx-ellipsis-vertical", '\uE929'),
	EXCLAMATION_CIRCLE("mfx-exclamation-circle", '\uE92A'),
	EXCLAMATION_CIRCLE_FILLED("mfx-exclamation-circle-filled", '\uE92B'),
	EXCLAMATION_TRIANGLE("mfx-exclamation-triangle", '\uE92C'),
	EXPAND("mfx-expand", '\uE92D'),
	EYE("mfx-eye", '\uE92E'),
	EYE_SLASH("mfx-eye-slash", '\uE92F'),
	FILE("mfx-file", '\uE930'),
	FILTER("mfx-filter", '\uE931'),
	FILTER_ALT("mfx-filter-alt", '\uE932'),
	FILTER_ALT_CLEAR("mfx-filter-alt-clear", '\uE933'),
	FIRST_PAGE("mfx-first-page", '\uE934'),
	FIT("mfx-fit", '\uE935'),
	FOLDER("mfx-folder", '\uE936'),
	FONTICONS("mfx-fonticons", '\uE937'),
	GEAR("mfx-gear", '\uE938'),
	GOOGLE("mfx-google", '\uE939'),
	GOOGLE_DRAWING("mfx-google-drawing", '\uE93A'),
	GOOGLE_DRIVE("mfx-google-drive", '\uE93B'),
	GOOGLE_FORMS("mfx-google-forms", '\uE93C'),
	GOOGLE_FUSION_TABLES("mfx-google-fusion-tables", '\uE93D'),
	GOOGLE_PRESENTATION("mfx-google-presentation", '\uE93E'),
	GOOGLE_SCRIPT("mfx-google-script", '\uE93F'),
	GOOGLE_SITES("mfx-google-sites", '\uE940'),
	HOME("mfx-home", '\uE941'),
	HYPHEN("mfx-hyphen", '\uE942'),
	IMAGE("mfx-image", '\uE943'),
	INFO("mfx-info", '\uE944'),
	INFO_CIRCLE("mfx-info-circle", '\uE945'),
	INFO_CIRCLE_FILLED("mfx-info-circle-filled", '\uE946'),
	INPUT_PIPE("mfx-input-pipe", '\uE947'),
	INPUT_PIPE_ALT("mfx-input-pipe-alt", '\uE948'),
	LAST_PAGE("mfx-last-page", '\uE949'),
	LEVEL_UP("mfx-level-up", '\uE94A'),
	LIST_DROPDOWN("mfx-list-dropdown", '\uE94B'),
	LOCK("mfx-lock", '\uE94C'),
	LOCK_OPEN("mfx-lock-open", '\uE94D'),
	LOGO("mfx-logo", '\uE94E'),
	LOGO_ALT("mfx-logo-alt", '\uE94F'),
	MAP("mfx-map", '\uE950'),
	MESSAGE("mfx-message", '\uE951'),
	MESSAGES("mfx-messages", '\uE952'),
	MINUS("mfx-minus", '\uE953'),
	MINUS_CIRCLE("mfx-minus-circle", '\uE954'),
	MODENA_MARK("mfx-modena-mark", '\uE955'),
	MUSIC("mfx-music", '\uE956'),
	NEXT("mfx-next", '\uE957'),
	PLUS("mfx-plus", '\uE958'),
	PROGRESS_BARS("mfx-progress-bars", '\uE959'),
	PROGRESS_BARS_ALT("mfx-progress-bars-alt", '\uE95A'),
	REDO("mfx-redo", '\uE95B'),
	RESTORE("mfx-restore", '\uE95C'),
	SCROLL_BAR("mfx-scroll-bar", '\uE95D'),
	SEARCH("mfx-search", '\uE95E'),
	SEARCH_PLUS("mfx-search-plus", '\uE95F'),
	SELECT_ALL("mfx-select-all", '\uE960'),
	SHORTCUT("mfx-shortcut", '\uE961'),
	SIDEBAR_CLOSE("mfx-sidebar-close", '\uE962'),
	SIDEBAR_OPEN("mfx-sidebar-open", '\uE963'),
	SLIDERS("mfx-sliders", '\uE964'),
	SPREADSHEET("mfx-spreadsheet", '\uE965'),
	SQUARE_LIST("mfx-square-list", '\uE966'),
	STEP_BACKWARD("mfx-step-backward", '\uE967'),
	STEP_FORWARD("mfx-step-forward", '\uE968'),
	STEPPER("mfx-stepper", '\uE969'),
	SYNC("mfx-sync", '\uE96A'),
	SYNC_LIGHT("mfx-sync-light", '\uE96B'),
	TABLE("mfx-table", '\uE96C'),
	TABLE_ALT("mfx-table-alt", '\uE96D'),
	TOGGLE_OFF("mfx-toggle-off", '\uE96E'),
	TOGGLE_ON("mfx-toggle-on", '\uE96F'),
	UNDO("mfx-undo", '\uE970'),
	USER("mfx-user", '\uE971'),
	USERS("mfx-users", '\uE972'),
	VARIANT10_MARK("mfx-variant10-mark", '\uE973'),
	VARIANT11_MARK("mfx-variant11-mark", '\uE974'),
	VARIANT12_MARK("mfx-variant12-mark", '\uE975'),
	VARIANT13_MARK("mfx-variant13-mark", '\uE976'),
	VARIANT14_MARK("mfx-variant14-mark", '\uE977'),
	VARIANT3_MARK("mfx-variant3-mark", '\uE978'),
	VARIANT4_MARK("mfx-variant4-mark", '\uE979'),
	VARIANT5_MARK("mfx-variant5-mark", '\uE97A'),
	VARIANT6_MARK("mfx-variant6-mark", '\uE97B'),
	VARIANT7_MARK("mfx-variant7-mark", '\uE97C'),
	VARIANT8_MARK("mfx-variant8-mark", '\uE97D'),
	VARIANT9_MARK("mfx-variant9-mark", '\uE97E'),
	VIDEO("mfx-video", '\uE97F'),
	X("mfx-x", '\uE980'),
	X_ALT("mfx-x-alt", '\uE981'),
	X_CIRCLE("mfx-x-circle", '\uE982'),
	X_CIRCLE_LIGHT("mfx-x-circle-light", '\uE983'),
	X_LIGHT("mfx-x-light", '\uE984');

	public static FontResources findByDescription(String description) {
		for (FontResources font : values()) {
			if (font.getDescription().equals(description)) {
				return font;
			}
		}
		throw new IllegalArgumentException("Icon description '" + description + "' is invalid!");
	}

	private final String description;
	private final char code;

	FontResources(String description, char code) {
		this.description = description;
		this.code = code;
	}

	public String getDescription() {
		return description;
	}

	public char getCode() {
		return code;
	}

}
