/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.bindings.base;

import java.util.function.BiConsumer;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public abstract class AbstractBindingHelper<T> {
    protected ObservableValue<? extends T> target;
    protected BiConsumer<T, T> targetUpdater;
    protected final ChangeListener<? super T> sourceListener = this::updateTarget;

    public abstract AbstractBindingHelper<T> bind(ObservableValue<? extends T> var1);

    public abstract AbstractBindingHelper<T> with(BiConsumer<T, T> var1);

    public abstract void invalidate();

    public abstract void dispose();

    public abstract boolean isDispose();

    protected void updateTarget(ObservableValue<? extends T> source, T oldValue, T newValue) {
        this.beforeUpdateTarget();
        this.targetUpdater.accept(oldValue, newValue);
        this.afterUpdateTarget();
    }

    protected void beforeUpdateTarget() {
    }

    protected void afterUpdateTarget() {
    }

    protected void beforeBind() {
    }

    protected void afterBind() {
    }

    protected void beforeUnbind() {
    }

    protected void afterUnbind() {
    }
}

