/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.builders.control;

import io.github.palexdev.materialfx.builders.base.BaseListViewBuilder;
import io.github.palexdev.materialfx.controls.MFXCheckListView;
import io.github.palexdev.materialfx.controls.cell.MFXCheckListCell;
import java.util.function.Function;

public class CheckListBuilder<T>
extends BaseListViewBuilder<T, MFXCheckListCell<T>, MFXCheckListView<T>> {
    public CheckListBuilder() {
        this(new MFXCheckListView());
    }

    public CheckListBuilder(MFXCheckListView<T> listView) {
        super(listView);
    }

    public static <T> CheckListBuilder<T> checkList() {
        return new CheckListBuilder<T>();
    }

    public static <T> CheckListBuilder<T> checkList(MFXCheckListView<T> checkListView) {
        return new CheckListBuilder<T>(checkListView);
    }

    public CheckListBuilder<T> scrollBy(double pixels) {
        ((MFXCheckListView)this.node).scrollBy(pixels);
        return this;
    }

    public CheckListBuilder<T> scrollTo(int index) {
        ((MFXCheckListView)this.node).scrollTo(index);
        return this;
    }

    public CheckListBuilder<T> scrollToFirst() {
        ((MFXCheckListView)this.node).scrollToFirst();
        return this;
    }

    public CheckListBuilder<T> scrollToLast() {
        ((MFXCheckListView)this.node).scrollToLast();
        return this;
    }

    public CheckListBuilder<T> scrollToPixel(double pixel) {
        ((MFXCheckListView)this.node).scrollToPixel(pixel);
        return this;
    }

    public CheckListBuilder<T> setHSpeed(double unit, double block) {
        ((MFXCheckListView)this.node).setHSpeed(unit, block);
        return this;
    }

    public CheckListBuilder<T> setVSpeed(double unit, double block) {
        ((MFXCheckListView)this.node).setVSpeed(unit, block);
        return this;
    }

    public CheckListBuilder<T> setCellFactory(Function<T, MFXCheckListCell<T>> cellFactory) {
        ((MFXCheckListView)this.node).setCellFactory(cellFactory);
        return this;
    }

    public CheckListBuilder<T> enableSmoothScrolling(double speed) {
        ((MFXCheckListView)this.node).features().enableSmoothScrolling(speed);
        return this;
    }

    public CheckListBuilder<T> enableSmoothScrolling(double speed, double trackPadAdjustment) {
        ((MFXCheckListView)this.node).features().enableSmoothScrolling(speed, trackPadAdjustment);
        return this;
    }

    public CheckListBuilder<T> enableSmoothScrolling(double speed, double trackPadAdjustment, double scrollThreshold) {
        ((MFXCheckListView)this.node).features().enableSmoothScrolling(speed, trackPadAdjustment, scrollThreshold);
        return this;
    }

    public CheckListBuilder<T> enableBounceEffect() {
        ((MFXCheckListView)this.node).features().enableBounceEffect();
        return this;
    }

    public CheckListBuilder<T> enableBounceEffect(double strength, double maxOverscroll) {
        ((MFXCheckListView)this.node).features().enableBounceEffect(strength, maxOverscroll);
        return this;
    }
}

