/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.builders.control;

import io.github.palexdev.materialfx.beans.PositionBean;
import io.github.palexdev.materialfx.controls.MFXTooltip;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javafx.animation.Animation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.transform.Scale;
import javafx.util.Duration;

public class TooltipBuilder {
    private final MFXTooltip tooltip;

    public TooltipBuilder(Node owner) {
        this(new MFXTooltip(owner));
    }

    public TooltipBuilder(MFXTooltip tooltip) {
        this.tooltip = tooltip;
    }

    public static MFXTooltip of(Node owner, String text) {
        return MFXTooltip.of(owner, text);
    }

    public static void disposeFor(Node node) {
        MFXTooltip.disposeFor(node);
    }

    public TooltipBuilder setPopupStyleableParent(Parent parent) {
        this.tooltip.setPopupStyleableParent(parent);
        return this;
    }

    public TooltipBuilder addStylesheet(String ... stylesheets) {
        this.tooltip.getStyleSheets().addAll((Object[])stylesheets);
        return this;
    }

    public TooltipBuilder setStylesheet(String ... stylesheets) {
        this.tooltip.getStyleSheets().setAll((Object[])stylesheets);
        return this;
    }

    public TooltipBuilder setAnimationProvider(BiFunction<Node, Scale, Animation> animationProvider) {
        this.tooltip.setAnimationProvider(animationProvider);
        return this;
    }

    public TooltipBuilder setAnimated(boolean animated) {
        this.tooltip.setAnimated(animated);
        return this;
    }

    public TooltipBuilder install() {
        this.tooltip.install();
        return this;
    }

    public TooltipBuilder uninstall() {
        this.tooltip.uninstall();
        return this;
    }

    public TooltipBuilder dispose() {
        this.tooltip.dispose();
        return this;
    }

    public TooltipBuilder setShowAction(Consumer<PositionBean> showAction) {
        this.tooltip.setShowAction(showAction);
        return this;
    }

    public TooltipBuilder setIcon(Node icon) {
        this.tooltip.setIcon(icon);
        return this;
    }

    public TooltipBuilder setText(String text) {
        this.tooltip.setText(text);
        return this;
    }

    public TooltipBuilder setShowDelay(Duration showDelay) {
        this.tooltip.setShowDelay(showDelay);
        return this;
    }

    public TooltipBuilder setHideAfter(Duration hideAfter) {
        this.tooltip.setHideAfter(hideAfter);
        return this;
    }
}

