/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.MFXResourcesLoader;
import io.github.palexdev.materialfx.beans.properties.functional.FunctionProperty;
import io.github.palexdev.materialfx.collections.TransformableList;
import io.github.palexdev.materialfx.collections.TransformableListWrapper;
import io.github.palexdev.materialfx.controls.MFXComboBox;
import io.github.palexdev.materialfx.controls.cell.MFXFilterComboBoxCell;
import io.github.palexdev.materialfx.skins.MFXFilterComboBoxSkin;
import io.github.palexdev.materialfx.utils.StringUtils;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Skin;

public class MFXFilterComboBox<T>
extends MFXComboBox<T> {
    private final String STYLECLASS = "mfx-filter-combo-box";
    private final String STYLESHEET = MFXResourcesLoader.load("css/MFXFilterComboBox.css");
    private final StringProperty searchText = new SimpleStringProperty();
    private final TransformableListWrapper<T> filterList = new TransformableListWrapper(FXCollections.observableArrayList());
    private final FunctionProperty<String, Predicate<T>> filterFunction = new FunctionProperty<String, Predicate>(s -> t -> StringUtils.containsIgnoreCase(t.toString(), s));
    private boolean resetOnPopupHidden = true;
    private final InvalidationListener itemsChanged = invalidated -> this.filterList.setAll(this.getItems());

    public MFXFilterComboBox() {
        this.initialize();
    }

    public MFXFilterComboBox(ObservableList<T> items) {
        super(items);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-filter-combo-box");
        this.setCellFactory(t -> new MFXFilterComboBoxCell<Object>(this, this.getFilterList(), t));
        this.filterList.setAll(this.getItems());
        this.itemsProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.removeListener(this.itemsChanged);
            }
            if (newValue != null) {
                newValue.addListener(this.itemsChanged);
                this.filterList.setAll((Collection<T>)newValue);
            }
        });
        this.getItems().addListener(this.itemsChanged);
    }

    public String getSearchText() {
        return (String)this.searchText.get();
    }

    public StringProperty searchTextProperty() {
        return this.searchText;
    }

    public void setSearchText(String searchText) {
        this.searchText.set((Object)searchText);
    }

    public TransformableList<T> getFilterList() {
        return this.filterList.getTransformableList();
    }

    public Function<String, Predicate<T>> getFilterFunction() {
        return (Function)this.filterFunction.get();
    }

    public FunctionProperty<String, Predicate<T>> filterFunctionProperty() {
        return this.filterFunction;
    }

    public void setFilterFunction(Function<String, Predicate<T>> filterFunction) {
        this.filterFunction.set(filterFunction);
    }

    public boolean isResetOnPopupHidden() {
        return this.resetOnPopupHidden;
    }

    public void setResetOnPopupHidden(boolean resetOnPopupHidden) {
        this.resetOnPopupHidden = resetOnPopupHidden;
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new MFXFilterComboBoxSkin(this, this.boundField);
    }

    @Override
    public String getUserAgentStylesheet() {
        return this.STYLESHEET;
    }
}

