/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.MFXResourcesLoader;
import io.github.palexdev.materialfx.controls.base.MFXLabeled;
import io.github.palexdev.materialfx.skins.MFXRadioButtonSkin;
import io.github.palexdev.materialfx.utils.StyleablePropertiesUtils;
import java.util.List;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Skin;

public class MFXRadioButton
extends RadioButton
implements MFXLabeled {
    private static final StyleablePropertyFactory<MFXRadioButton> FACTORY = new StyleablePropertyFactory(RadioButton.getClassCssMetaData());
    private final String STYLE_CLASS = "mfx-radio-button";
    private final String STYLESHEET = MFXResourcesLoader.load("css/MFXRadioButton.css");
    private final StyleableObjectProperty<ContentDisplay> contentDisposition = new SimpleStyleableObjectProperty<ContentDisplay>(StyleableProperties.CONTENT_DISPOSITION, (Object)this, "contentDisposition", ContentDisplay.LEFT){

        public StyleOrigin getStyleOrigin() {
            return StyleOrigin.USER_AGENT;
        }
    };
    private final StyleableDoubleProperty gap = new SimpleStyleableDoubleProperty(StyleableProperties.GAP, (Object)this, "gap", Double.valueOf(8.0));
    private final StyleableDoubleProperty radioGap = new SimpleStyleableDoubleProperty(StyleableProperties.RADIO_GAP, this, "radioGap", 3.5){

        public StyleOrigin getStyleOrigin() {
            return StyleOrigin.USER_AGENT;
        }
    };
    private final StyleableDoubleProperty radius = new SimpleStyleableDoubleProperty(StyleableProperties.RADIUS, (Object)this, "radius", Double.valueOf(8.0));
    private final StyleableBooleanProperty textExpand = new SimpleStyleableBooleanProperty(StyleableProperties.TEXT_EXPAND, (Object)this, "textExpand", false);

    public MFXRadioButton() {
        this("");
    }

    public MFXRadioButton(String text) {
        super(text);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-radio-button");
    }

    @Override
    public ContentDisplay getContentDisposition() {
        return (ContentDisplay)this.contentDisposition.get();
    }

    @Override
    public StyleableObjectProperty<ContentDisplay> contentDispositionProperty() {
        return this.contentDisposition;
    }

    @Override
    public void setContentDisposition(ContentDisplay contentDisposition) {
        this.contentDisposition.set((Object)contentDisposition);
    }

    @Override
    public double getGap() {
        return this.gap.get();
    }

    @Override
    public StyleableDoubleProperty gapProperty() {
        return this.gap;
    }

    @Override
    public void setGap(double gap) {
        this.gap.set(gap);
    }

    public double getRadioGap() {
        return this.radioGap.get();
    }

    public StyleableDoubleProperty radioGapProperty() {
        return this.radioGap;
    }

    public void setRadioGap(double radioGap) {
        this.radioGap.set(radioGap);
    }

    public double getRadius() {
        return this.radius.get();
    }

    public StyleableDoubleProperty radiusProperty() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius.set(radius);
    }

    @Override
    public boolean isTextExpand() {
        return this.textExpand.get();
    }

    @Override
    public StyleableBooleanProperty textExpandProperty() {
        return this.textExpand;
    }

    @Override
    public void setTextExpand(boolean textExpand) {
        this.textExpand.set(textExpand);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getControlCssMetaDataList() {
        return StyleableProperties.cssMetaDataList;
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXRadioButtonSkin(this);
    }

    public String getUserAgentStylesheet() {
        return this.STYLESHEET;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return MFXRadioButton.getControlCssMetaDataList();
    }

    private static class StyleableProperties {
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<MFXRadioButton, ContentDisplay> CONTENT_DISPOSITION;
        private static final CssMetaData<MFXRadioButton, Number> GAP;
        private static final CssMetaData<MFXRadioButton, Number> RADIO_GAP;
        private static final CssMetaData<MFXRadioButton, Number> RADIUS;
        private static final CssMetaData<MFXRadioButton, Boolean> TEXT_EXPAND;

        private StyleableProperties() {
        }

        static {
            CONTENT_DISPOSITION = FACTORY.createEnumCssMetaData(ContentDisplay.class, "-mfx-content-disposition", MFXRadioButton::contentDispositionProperty, (Enum)ContentDisplay.LEFT);
            GAP = FACTORY.createSizeCssMetaData("-mfx-gap", MFXRadioButton::gapProperty, (Number)8.0);
            RADIO_GAP = FACTORY.createSizeCssMetaData("-mfx-radio-gap", MFXRadioButton::radioGapProperty, (Number)3.5);
            RADIUS = FACTORY.createSizeCssMetaData("-mfx-radius", MFXRadioButton::radiusProperty, (Number)8.0);
            TEXT_EXPAND = FACTORY.createBooleanCssMetaData("-mfx-text-expand", MFXRadioButton::textExpandProperty, false);
            cssMetaDataList = StyleablePropertiesUtils.cssMetaDataList(RadioButton.getClassCssMetaData(), CONTENT_DISPOSITION, GAP, RADIO_GAP, RADIUS, TEXT_EXPAND);
        }
    }
}

