/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.filter.base;

import io.github.palexdev.materialfx.beans.BiPredicateBean;
import io.github.palexdev.materialfx.beans.FilterBean;
import io.github.palexdev.materialfx.enums.ChainMode;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.ObservableList;
import javafx.util.StringConverter;

public abstract class AbstractFilter<T, U> {
    private final String name;
    private final Function<T, U> extractor;
    protected final ObservableList<BiPredicateBean<U, U>> predicates;
    protected final IntegerProperty selectedPredicateIndex = new SimpleIntegerProperty(-1);
    protected final StringConverter<U> converter;

    public AbstractFilter(String name, Function<T, U> extractor, StringConverter<U> converter) {
        this.name = name;
        this.extractor = extractor;
        this.converter = converter;
        this.predicates = this.defaultPredicates();
    }

    protected abstract ObservableList<BiPredicateBean<U, U>> defaultPredicates();

    protected abstract AbstractFilter<T, U> extend(BiPredicateBean<U, U> ... var1);

    public U getValue(String input) {
        return (U)this.getConverter().fromString(input);
    }

    public Predicate<T> predicateFor(String input) {
        this.checkIndex();
        int index = this.getSelectedPredicateIndex();
        U convertedInput = this.getValue(input);
        return t -> ((BiPredicateBean)this.predicates.get(index)).predicate().test(this.extractor.apply(t), convertedInput);
    }

    public Predicate<T> predicateFor(String input, BiPredicate<U, U> biPredicate) {
        U convertedInput = this.getValue(input);
        return t -> biPredicate.test(this.extractor.apply(t), convertedInput);
    }

    public FilterBean<T, U> toFilterBean(String input) {
        this.checkIndex();
        int index = this.getSelectedPredicateIndex();
        BiPredicateBean bean = (BiPredicateBean)this.predicates.get(index);
        return new FilterBean(input, this, bean);
    }

    public FilterBean<T, U> toFilterBean(String input, ChainMode mode) {
        this.checkIndex();
        int index = this.getSelectedPredicateIndex();
        BiPredicateBean bean = (BiPredicateBean)this.predicates.get(index);
        return new FilterBean(input, this, bean, mode);
    }

    public FilterBean<T, U> toFilterBean(String input, BiPredicateBean<U, U> bean, ChainMode mode) {
        return new FilterBean(input, this, bean, mode);
    }

    private void checkIndex() throws IllegalStateException {
        int index = this.getSelectedPredicateIndex();
        if (index < 0) {
            throw new IllegalStateException("No predicate selected for filter: " + this.name);
        }
    }

    public String name() {
        return this.name;
    }

    public Function<T, U> getExtractor() {
        return this.extractor;
    }

    public ObservableList<BiPredicateBean<U, U>> getPredicates() {
        return this.predicates;
    }

    public int getSelectedPredicateIndex() {
        return this.selectedPredicateIndex.get();
    }

    public IntegerProperty selectedPredicateIndexProperty() {
        return this.selectedPredicateIndex;
    }

    public void setSelectedPredicateIndex(int selectedPredicateIndex) {
        this.selectedPredicateIndex.set(selectedPredicateIndex);
    }

    public StringConverter<U> getConverter() {
        return this.converter;
    }

    public String toString() {
        return this.name;
    }
}

